package drr.regulation.cftc.rewrite.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.ClearingSwapUSIsReport;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ClearingSwapUSIsReportTypeFormatValidator implements Validator<ClearingSwapUSIsReport> {

	private List<ComparisonResult> getComparisonResults(ClearingSwapUSIsReport o) {
		return Lists.<ComparisonResult>newArrayList(
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ClearingSwapUSIsReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ClearingSwapUSIsReport", ValidationResult.ValidationType.TYPE_FORMAT, "ClearingSwapUSIsReport", path, "", res.getError());
				}
				return success("ClearingSwapUSIsReport", ValidationResult.ValidationType.TYPE_FORMAT, "ClearingSwapUSIsReport", path, "");
			})
			.collect(toList());
	}

}
