package drr.regulation.cftc.rewrite.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.ClearingSwapUTIsReport;
import java.util.List;
import java.util.regex.Pattern;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkString;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class ClearingSwapUTIsReportTypeFormatValidator implements Validator<ClearingSwapUTIsReport> {

	private List<ComparisonResult> getComparisonResults(ClearingSwapUTIsReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkString("identifier", o.getIdentifier(), 1, of(52), of(Pattern.compile("[a-zA-Z0-9]{1,52}")))
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ClearingSwapUTIsReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ClearingSwapUTIsReport", ValidationResult.ValidationType.TYPE_FORMAT, "ClearingSwapUTIsReport", path, "", res.getError());
				}
				return success("ClearingSwapUTIsReport", ValidationResult.ValidationType.TYPE_FORMAT, "ClearingSwapUTIsReport", path, "");
			})
			.collect(toList());
	}

}
