package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("CFTCPart43TransactionReportPriceCondition")
@ImplementedBy(CFTCPart43TransactionReportPriceCondition.Default.class)
public interface CFTCPart43TransactionReportPriceCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportPriceCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Equity\" and spreadLeg1 is absent and spreadLeg2 is absent and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then price exists else if cftcGuidebook -> assetClass = \"Commodity\" and ((fixedRateLeg1 is absent and fixedRateLeg2 is absent) or (spreadLeg1 is absent and spreadLeg2 is absent)) and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then price exists else price is absent";
	
	class Default implements CFTCPart43TransactionReportPriceCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), MapperS.of("Equity"), CardinalityOperator.All).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadLeg1()))).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadLeg2()))).andNullSafe(areEqual(MapperS.of(cFTCPart43TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getOptionStyle()))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getPrice", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPrice()));
				}
				if (areEqual(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getFixedRateLeg2()))).orNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadLeg2()))))).andNullSafe(areEqual(MapperS.of(cFTCPart43TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getOptionStyle()))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getPrice", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPrice()));
				}
				return notExists(MapperS.of(cFTCPart43TransactionReport).<BigDecimal>map("getPrice", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getPrice()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportPriceCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
