package drr.regulation.cftc.rewrite.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart43;
import drr.regulation.cftc.rewrite.CFTCPart43TransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("CFTCPart43TransactionReportSpreadCurrencyCondition")
@ImplementedBy(CFTCPart43TransactionReportSpreadCurrencyCondition.Default.class)
public interface CFTCPart43TransactionReportSpreadCurrencyCondition extends Validator<CFTCPart43TransactionReport> {
	
	String NAME = "CFTCPart43TransactionReportSpreadCurrencyCondition";
	String DEFINITION = "(if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and spreadNotationLeg1 = \"1\" then spreadCurrencyLeg1 exists else spreadCurrencyLeg1 is absent) and (if [\"Credit\", \"InterestRate\", \"Equity\", \"Commodity\"] any = cftcGuidebook -> assetClass and spreadNotationLeg2 = \"1\" then spreadCurrencyLeg2 exists else spreadCurrencyLeg2 is absent)";
	
	class Default implements CFTCPart43TransactionReportSpreadCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart43TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart43TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			try {
				final ComparisonResult ifThenElseResult0;
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(cFTCPart43TransactionReport).<String>map("getSpreadNotationLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadNotationLeg1()), MapperS.of("1"), CardinalityOperator.All)).getOrDefault(false)) {
					ifThenElseResult0 = exists(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadCurrencyLeg1()));
				} else {
					ifThenElseResult0 = notExists(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg1", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadCurrencyLeg1()));
				}
				final ComparisonResult ifThenElseResult1;
				if (areEqual(MapperC.<String>of(MapperS.of("Credit"), MapperS.of("InterestRate"), MapperS.of("Equity"), MapperS.of("Commodity")), MapperS.of(cFTCPart43TransactionReport).<CFTCGuidebookPart43>map("getCftcGuidebook", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart43 -> cFTCGuidebookPart43.getAssetClass()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(cFTCPart43TransactionReport).<String>map("getSpreadNotationLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadNotationLeg2()), MapperS.of("1"), CardinalityOperator.All)).getOrDefault(false)) {
					ifThenElseResult1 = exists(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadCurrencyLeg2()));
				} else {
					ifThenElseResult1 = notExists(MapperS.of(cFTCPart43TransactionReport).<ISOCurrencyCodeEnum>map("getSpreadCurrencyLeg2", _cFTCPart43TransactionReport -> _cFTCPart43TransactionReport.getSpreadCurrencyLeg2()));
				}
				return ifThenElseResult0.andNullSafe(ifThenElseResult1);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart43TransactionReportSpreadCurrencyCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart43TransactionReport cFTCPart43TransactionReport) {
			return Collections.emptyList();
		}
	}
}
