package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("CFTCPart45TransactionReportNotionalAmountCondition")
@ImplementedBy(CFTCPart45TransactionReportNotionalAmountCondition.Default.class)
public interface CFTCPart45TransactionReportNotionalAmountCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportNotionalAmountCondition";
	String DEFINITION = "if cftcGuidebook -> optionStyle exists then ((if notionalAmountLeg1 exists then notionalAmountLeg1 any = [callAmount, putAmount] else True) and (if notionalAmountLeg2 exists then notionalAmountLeg1 any = [callAmount, putAmount] else True))";
	
	class Default implements CFTCPart45TransactionReportNotionalAmountCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (exists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle())).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult0;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getNotionalAmountLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNotionalAmountLeg1())).getOrDefault(false)) {
						ifThenElseResult0 = areEqual(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getNotionalAmountLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNotionalAmountLeg1()), MapperC.<BigDecimal>of(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getCallAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallAmount()), MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPutAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutAmount())), CardinalityOperator.Any);
					} else {
						ifThenElseResult0 = ComparisonResult.ofNullSafe(MapperS.of(true));
					}
					final ComparisonResult ifThenElseResult1;
					if (exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getNotionalAmountLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNotionalAmountLeg2())).getOrDefault(false)) {
						ifThenElseResult1 = areEqual(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getNotionalAmountLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNotionalAmountLeg1()), MapperC.<BigDecimal>of(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getCallAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCallAmount()), MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPutAmount", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPutAmount())), CardinalityOperator.Any);
					} else {
						ifThenElseResult1 = ComparisonResult.ofNullSafe(MapperS.of(true));
					}
					return ifThenElseResult0.andNullSafe(ifThenElseResult1);
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportNotionalAmountCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
