package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("CFTCPart45TransactionReportPriceCondition")
@ImplementedBy(CFTCPart45TransactionReportPriceCondition.Default.class)
public interface CFTCPart45TransactionReportPriceCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportPriceCondition";
	String DEFINITION = "if cftcGuidebook -> assetClass = \"Equity\" and spreadLeg1 is absent and spreadLeg2 is absent and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then price exists else if cftcGuidebook -> assetClass = \"Commodity\" and ((fixedRateLeg1 is absent and fixedRateLeg2 is absent) or (spreadLeg1 is absent and spreadLeg2 is absent)) and postPricedSwapIndicator = False and cftcGuidebook -> optionStyle is absent then price exists else price is absent";
	
	class Default implements CFTCPart45TransactionReportPriceCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Equity"), CardinalityOperator.All).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1()))).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()))).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice()));
				}
				if (areEqual(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), MapperS.of("Commodity"), CardinalityOperator.All).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getFixedRateLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getFixedRateLeg2()))).orNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getSpreadLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getSpreadLeg2()))))).andNullSafe(areEqual(MapperS.of(cFTCPart45TransactionReport).<Boolean>map("getPostPricedSwapIndicator", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPostPricedSwapIndicator()), MapperS.of(false), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getOptionStyle", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getOptionStyle()))).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice()));
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getPrice", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getPrice()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportPriceCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
