package drr.regulation.cftc.rewrite.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.CFTCGuidebookPart45;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("CFTCPart45TransactionReportTotalNotionalQuantityCondition")
@ImplementedBy(CFTCPart45TransactionReportTotalNotionalQuantityCondition.Default.class)
public interface CFTCPart45TransactionReportTotalNotionalQuantityCondition extends Validator<CFTCPart45TransactionReport> {
	
	String NAME = "CFTCPart45TransactionReportTotalNotionalQuantityCondition";
	String DEFINITION = "if [\"Commodity\", \"Equity\"] any = cftcGuidebook -> assetClass then totalNotionalQuantityLeg1 exists or totalNotionalQuantityLeg2 exists else totalNotionalQuantityLeg1 is absent and totalNotionalQuantityLeg2 is absent";
	
	class Default implements CFTCPart45TransactionReportTotalNotionalQuantityCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			ComparisonResult result = executeDataRule(cFTCPart45TransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CFTCPart45TransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of("Commodity"), MapperS.of("Equity")), MapperS.of(cFTCPart45TransactionReport).<CFTCGuidebookPart45>map("getCftcGuidebook", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getCftcGuidebook()).<String>map("getAssetClass", cFTCGuidebookPart45 -> cFTCGuidebookPart45.getAssetClass()), CardinalityOperator.Any).getOrDefault(false)) {
					return exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getTotalNotionalQuantityLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getTotalNotionalQuantityLeg1())).orNullSafe(exists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getTotalNotionalQuantityLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getTotalNotionalQuantityLeg2())));
				}
				return notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getTotalNotionalQuantityLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getTotalNotionalQuantityLeg1())).andNullSafe(notExists(MapperS.of(cFTCPart45TransactionReport).<BigDecimal>map("getTotalNotionalQuantityLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getTotalNotionalQuantityLeg2())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CFTCPart45TransactionReportTotalNotionalQuantityCondition {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
			return Collections.emptyList();
		}
	}
}
