package drr.regulation.cftc.tr.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ExecutionVenueTypeEnum;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(LargeNotionalOffFacilitySwapElectionIndicatorRule.LargeNotionalOffFacilitySwapElectionIndicatorRuleDefault.class)
public abstract class LargeNotionalOffFacilitySwapElectionIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class LargeNotionalOffFacilitySwapElectionIndicatorRuleDefault extends LargeNotionalOffFacilitySwapElectionIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperS<ReportableInformation> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()));
			final MapperS<ReportableInformation> thenArg1 = thenArg0
				.filterSingleNullSafe(item -> areEqual(item.<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.Any).get());
			output = thenArg1
				.mapSingleToItem(item -> {
					if (areEqual(item.<Boolean>map("getLargeSizeTrade", reportableInformation -> reportableInformation.getLargeSizeTrade()), MapperS.of(true), CardinalityOperator.All).andNullSafe(notEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.SEF), CardinalityOperator.Any).andNullSafe(notEqual(item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType()), MapperS.of(ExecutionVenueTypeEnum.DCM), CardinalityOperator.Any))).getOrDefault(false)) {
						return MapperS.of(true);
					}
					return MapperS.of(false);
				}).get();
			
			return output;
		}
	}
}
