package drr.regulation.common;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.meta.QuantityReportablePeriodMeta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.58.0
 */
@RosettaDataType(value="QuantityReportablePeriod", builder=QuantityReportablePeriod.QuantityReportablePeriodBuilderImpl.class, version="5.58.0")
@RuneDataType(value="QuantityReportablePeriod", model="drr", builder=QuantityReportablePeriod.QuantityReportablePeriodBuilderImpl.class, version="5.58.0")
public interface QuantityReportablePeriod extends RosettaModelObject {

	QuantityReportablePeriodMeta metaData = new QuantityReportablePeriodMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getPeriodValue();
	Date getPeriodEffectiveDate();
	Date getPeriodEndDate();

	/*********************** Build Methods  ***********************/
	QuantityReportablePeriod build();
	
	QuantityReportablePeriod.QuantityReportablePeriodBuilder toBuilder();
	
	static QuantityReportablePeriod.QuantityReportablePeriodBuilder builder() {
		return new QuantityReportablePeriod.QuantityReportablePeriodBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends QuantityReportablePeriod> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends QuantityReportablePeriod> getType() {
		return QuantityReportablePeriod.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("periodValue"), BigDecimal.class, getPeriodValue(), this);
		processor.processBasic(path.newSubPath("periodEffectiveDate"), Date.class, getPeriodEffectiveDate(), this);
		processor.processBasic(path.newSubPath("periodEndDate"), Date.class, getPeriodEndDate(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface QuantityReportablePeriodBuilder extends QuantityReportablePeriod, RosettaModelObjectBuilder {
		QuantityReportablePeriod.QuantityReportablePeriodBuilder setPeriodValue(BigDecimal periodValue);
		QuantityReportablePeriod.QuantityReportablePeriodBuilder setPeriodEffectiveDate(Date periodEffectiveDate);
		QuantityReportablePeriod.QuantityReportablePeriodBuilder setPeriodEndDate(Date periodEndDate);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("periodValue"), BigDecimal.class, getPeriodValue(), this);
			processor.processBasic(path.newSubPath("periodEffectiveDate"), Date.class, getPeriodEffectiveDate(), this);
			processor.processBasic(path.newSubPath("periodEndDate"), Date.class, getPeriodEndDate(), this);
		}
		

		QuantityReportablePeriod.QuantityReportablePeriodBuilder prune();
	}

	/*********************** Immutable Implementation of QuantityReportablePeriod  ***********************/
	class QuantityReportablePeriodImpl implements QuantityReportablePeriod {
		private final BigDecimal periodValue;
		private final Date periodEffectiveDate;
		private final Date periodEndDate;
		
		protected QuantityReportablePeriodImpl(QuantityReportablePeriod.QuantityReportablePeriodBuilder builder) {
			this.periodValue = builder.getPeriodValue();
			this.periodEffectiveDate = builder.getPeriodEffectiveDate();
			this.periodEndDate = builder.getPeriodEndDate();
		}
		
		@Override
		@RosettaAttribute(value="periodValue", isRequired=true)
		@RuneAttribute(value="periodValue", isRequired=true)
		public BigDecimal getPeriodValue() {
			return periodValue;
		}
		
		@Override
		@RosettaAttribute(value="periodEffectiveDate", isRequired=true)
		@RuneAttribute(value="periodEffectiveDate", isRequired=true)
		public Date getPeriodEffectiveDate() {
			return periodEffectiveDate;
		}
		
		@Override
		@RosettaAttribute("periodEndDate")
		@RuneAttribute("periodEndDate")
		public Date getPeriodEndDate() {
			return periodEndDate;
		}
		
		@Override
		public QuantityReportablePeriod build() {
			return this;
		}
		
		@Override
		public QuantityReportablePeriod.QuantityReportablePeriodBuilder toBuilder() {
			QuantityReportablePeriod.QuantityReportablePeriodBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(QuantityReportablePeriod.QuantityReportablePeriodBuilder builder) {
			ofNullable(getPeriodValue()).ifPresent(builder::setPeriodValue);
			ofNullable(getPeriodEffectiveDate()).ifPresent(builder::setPeriodEffectiveDate);
			ofNullable(getPeriodEndDate()).ifPresent(builder::setPeriodEndDate);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			QuantityReportablePeriod _that = getType().cast(o);
		
			if (!Objects.equals(periodValue, _that.getPeriodValue())) return false;
			if (!Objects.equals(periodEffectiveDate, _that.getPeriodEffectiveDate())) return false;
			if (!Objects.equals(periodEndDate, _that.getPeriodEndDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (periodValue != null ? periodValue.hashCode() : 0);
			_result = 31 * _result + (periodEffectiveDate != null ? periodEffectiveDate.hashCode() : 0);
			_result = 31 * _result + (periodEndDate != null ? periodEndDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "QuantityReportablePeriod {" +
				"periodValue=" + this.periodValue + ", " +
				"periodEffectiveDate=" + this.periodEffectiveDate + ", " +
				"periodEndDate=" + this.periodEndDate +
			'}';
		}
	}

	/*********************** Builder Implementation of QuantityReportablePeriod  ***********************/
	class QuantityReportablePeriodBuilderImpl implements QuantityReportablePeriod.QuantityReportablePeriodBuilder {
	
		protected BigDecimal periodValue;
		protected Date periodEffectiveDate;
		protected Date periodEndDate;
		
		@Override
		@RosettaAttribute(value="periodValue", isRequired=true)
		@RuneAttribute(value="periodValue", isRequired=true)
		public BigDecimal getPeriodValue() {
			return periodValue;
		}
		
		@Override
		@RosettaAttribute(value="periodEffectiveDate", isRequired=true)
		@RuneAttribute(value="periodEffectiveDate", isRequired=true)
		public Date getPeriodEffectiveDate() {
			return periodEffectiveDate;
		}
		
		@Override
		@RosettaAttribute("periodEndDate")
		@RuneAttribute("periodEndDate")
		public Date getPeriodEndDate() {
			return periodEndDate;
		}
		
		@RosettaAttribute(value="periodValue", isRequired=true)
		@RuneAttribute(value="periodValue", isRequired=true)
		@Override
		public QuantityReportablePeriod.QuantityReportablePeriodBuilder setPeriodValue(BigDecimal _periodValue) {
			this.periodValue = _periodValue == null ? null : _periodValue;
			return this;
		}
		
		@RosettaAttribute(value="periodEffectiveDate", isRequired=true)
		@RuneAttribute(value="periodEffectiveDate", isRequired=true)
		@Override
		public QuantityReportablePeriod.QuantityReportablePeriodBuilder setPeriodEffectiveDate(Date _periodEffectiveDate) {
			this.periodEffectiveDate = _periodEffectiveDate == null ? null : _periodEffectiveDate;
			return this;
		}
		
		@RosettaAttribute("periodEndDate")
		@RuneAttribute("periodEndDate")
		@Override
		public QuantityReportablePeriod.QuantityReportablePeriodBuilder setPeriodEndDate(Date _periodEndDate) {
			this.periodEndDate = _periodEndDate == null ? null : _periodEndDate;
			return this;
		}
		
		@Override
		public QuantityReportablePeriod build() {
			return new QuantityReportablePeriod.QuantityReportablePeriodImpl(this);
		}
		
		@Override
		public QuantityReportablePeriod.QuantityReportablePeriodBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public QuantityReportablePeriod.QuantityReportablePeriodBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPeriodValue()!=null) return true;
			if (getPeriodEffectiveDate()!=null) return true;
			if (getPeriodEndDate()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public QuantityReportablePeriod.QuantityReportablePeriodBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			QuantityReportablePeriod.QuantityReportablePeriodBuilder o = (QuantityReportablePeriod.QuantityReportablePeriodBuilder) other;
			
			
			merger.mergeBasic(getPeriodValue(), o.getPeriodValue(), this::setPeriodValue);
			merger.mergeBasic(getPeriodEffectiveDate(), o.getPeriodEffectiveDate(), this::setPeriodEffectiveDate);
			merger.mergeBasic(getPeriodEndDate(), o.getPeriodEndDate(), this::setPeriodEndDate);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			QuantityReportablePeriod _that = getType().cast(o);
		
			if (!Objects.equals(periodValue, _that.getPeriodValue())) return false;
			if (!Objects.equals(periodEffectiveDate, _that.getPeriodEffectiveDate())) return false;
			if (!Objects.equals(periodEndDate, _that.getPeriodEndDate())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (periodValue != null ? periodValue.hashCode() : 0);
			_result = 31 * _result + (periodEffectiveDate != null ? periodEffectiveDate.hashCode() : 0);
			_result = 31 * _result + (periodEndDate != null ? periodEndDate.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "QuantityReportablePeriodBuilder {" +
				"periodValue=" + this.periodValue + ", " +
				"periodEffectiveDate=" + this.periodEffectiveDate + ", " +
				"periodEndDate=" + this.periodEndDate +
			'}';
		}
	}
}
