package drr.regulation.common;

import cdm.event.common.TradeIdentifier;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.meta.ValuationTradeInformationMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.58.0
 */
@RosettaDataType(value="ValuationTradeInformation", builder=ValuationTradeInformation.ValuationTradeInformationBuilderImpl.class, version="5.58.0")
@RuneDataType(value="ValuationTradeInformation", model="drr", builder=ValuationTradeInformation.ValuationTradeInformationBuilderImpl.class, version="5.58.0")
public interface ValuationTradeInformation extends RosettaModelObject {

	ValuationTradeInformationMeta metaData = new ValuationTradeInformationMeta();

	/*********************** Getter Methods  ***********************/
	TradeIdentifier getUniqueTradeIdentifier();
	ActionTypeEnum getAction();
	Date getNextFloatingReferenceResetDateLeg1();
	Date getNextFloatingReferenceResetDateLeg2();

	/*********************** Build Methods  ***********************/
	ValuationTradeInformation build();
	
	ValuationTradeInformation.ValuationTradeInformationBuilder toBuilder();
	
	static ValuationTradeInformation.ValuationTradeInformationBuilder builder() {
		return new ValuationTradeInformation.ValuationTradeInformationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ValuationTradeInformation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ValuationTradeInformation> getType() {
		return ValuationTradeInformation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("uniqueTradeIdentifier"), processor, TradeIdentifier.class, getUniqueTradeIdentifier());
		processor.processBasic(path.newSubPath("action"), ActionTypeEnum.class, getAction(), this);
		processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, getNextFloatingReferenceResetDateLeg1(), this);
		processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, getNextFloatingReferenceResetDateLeg2(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ValuationTradeInformationBuilder extends ValuationTradeInformation, RosettaModelObjectBuilder {
		TradeIdentifier.TradeIdentifierBuilder getOrCreateUniqueTradeIdentifier();
		@Override
		TradeIdentifier.TradeIdentifierBuilder getUniqueTradeIdentifier();
		ValuationTradeInformation.ValuationTradeInformationBuilder setUniqueTradeIdentifier(TradeIdentifier uniqueTradeIdentifier);
		ValuationTradeInformation.ValuationTradeInformationBuilder setAction(ActionTypeEnum action);
		ValuationTradeInformation.ValuationTradeInformationBuilder setNextFloatingReferenceResetDateLeg1(Date nextFloatingReferenceResetDateLeg1);
		ValuationTradeInformation.ValuationTradeInformationBuilder setNextFloatingReferenceResetDateLeg2(Date nextFloatingReferenceResetDateLeg2);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("uniqueTradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, getUniqueTradeIdentifier());
			processor.processBasic(path.newSubPath("action"), ActionTypeEnum.class, getAction(), this);
			processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, getNextFloatingReferenceResetDateLeg1(), this);
			processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, getNextFloatingReferenceResetDateLeg2(), this);
		}
		

		ValuationTradeInformation.ValuationTradeInformationBuilder prune();
	}

	/*********************** Immutable Implementation of ValuationTradeInformation  ***********************/
	class ValuationTradeInformationImpl implements ValuationTradeInformation {
		private final TradeIdentifier uniqueTradeIdentifier;
		private final ActionTypeEnum action;
		private final Date nextFloatingReferenceResetDateLeg1;
		private final Date nextFloatingReferenceResetDateLeg2;
		
		protected ValuationTradeInformationImpl(ValuationTradeInformation.ValuationTradeInformationBuilder builder) {
			this.uniqueTradeIdentifier = ofNullable(builder.getUniqueTradeIdentifier()).map(f->f.build()).orElse(null);
			this.action = builder.getAction();
			this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
			this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
		}
		
		@Override
		@RosettaAttribute("uniqueTradeIdentifier")
		@RuneAttribute("uniqueTradeIdentifier")
		public TradeIdentifier getUniqueTradeIdentifier() {
			return uniqueTradeIdentifier;
		}
		
		@Override
		@RosettaAttribute("action")
		@RuneAttribute("action")
		public ActionTypeEnum getAction() {
			return action;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public Date getNextFloatingReferenceResetDateLeg1() {
			return nextFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public Date getNextFloatingReferenceResetDateLeg2() {
			return nextFloatingReferenceResetDateLeg2;
		}
		
		@Override
		public ValuationTradeInformation build() {
			return this;
		}
		
		@Override
		public ValuationTradeInformation.ValuationTradeInformationBuilder toBuilder() {
			ValuationTradeInformation.ValuationTradeInformationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ValuationTradeInformation.ValuationTradeInformationBuilder builder) {
			ofNullable(getUniqueTradeIdentifier()).ifPresent(builder::setUniqueTradeIdentifier);
			ofNullable(getAction()).ifPresent(builder::setAction);
			ofNullable(getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
			ofNullable(getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ValuationTradeInformation _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTradeIdentifier, _that.getUniqueTradeIdentifier())) return false;
			if (!Objects.equals(action, _that.getAction())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTradeIdentifier != null ? uniqueTradeIdentifier.hashCode() : 0);
			_result = 31 * _result + (action != null ? action.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg1 != null ? nextFloatingReferenceResetDateLeg1.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg2 != null ? nextFloatingReferenceResetDateLeg2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ValuationTradeInformation {" +
				"uniqueTradeIdentifier=" + this.uniqueTradeIdentifier + ", " +
				"action=" + this.action + ", " +
				"nextFloatingReferenceResetDateLeg1=" + this.nextFloatingReferenceResetDateLeg1 + ", " +
				"nextFloatingReferenceResetDateLeg2=" + this.nextFloatingReferenceResetDateLeg2 +
			'}';
		}
	}

	/*********************** Builder Implementation of ValuationTradeInformation  ***********************/
	class ValuationTradeInformationBuilderImpl implements ValuationTradeInformation.ValuationTradeInformationBuilder {
	
		protected TradeIdentifier.TradeIdentifierBuilder uniqueTradeIdentifier;
		protected ActionTypeEnum action;
		protected Date nextFloatingReferenceResetDateLeg1;
		protected Date nextFloatingReferenceResetDateLeg2;
		
		@Override
		@RosettaAttribute("uniqueTradeIdentifier")
		@RuneAttribute("uniqueTradeIdentifier")
		public TradeIdentifier.TradeIdentifierBuilder getUniqueTradeIdentifier() {
			return uniqueTradeIdentifier;
		}
		
		@Override
		public TradeIdentifier.TradeIdentifierBuilder getOrCreateUniqueTradeIdentifier() {
			TradeIdentifier.TradeIdentifierBuilder result;
			if (uniqueTradeIdentifier!=null) {
				result = uniqueTradeIdentifier;
			}
			else {
				result = uniqueTradeIdentifier = TradeIdentifier.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("action")
		@RuneAttribute("action")
		public ActionTypeEnum getAction() {
			return action;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		public Date getNextFloatingReferenceResetDateLeg1() {
			return nextFloatingReferenceResetDateLeg1;
		}
		
		@Override
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		public Date getNextFloatingReferenceResetDateLeg2() {
			return nextFloatingReferenceResetDateLeg2;
		}
		
		@RosettaAttribute("uniqueTradeIdentifier")
		@RuneAttribute("uniqueTradeIdentifier")
		@Override
		public ValuationTradeInformation.ValuationTradeInformationBuilder setUniqueTradeIdentifier(TradeIdentifier _uniqueTradeIdentifier) {
			this.uniqueTradeIdentifier = _uniqueTradeIdentifier == null ? null : _uniqueTradeIdentifier.toBuilder();
			return this;
		}
		
		@RosettaAttribute("action")
		@RuneAttribute("action")
		@Override
		public ValuationTradeInformation.ValuationTradeInformationBuilder setAction(ActionTypeEnum _action) {
			this.action = _action == null ? null : _action;
			return this;
		}
		
		@RosettaAttribute("nextFloatingReferenceResetDateLeg1")
		@RuneAttribute("nextFloatingReferenceResetDateLeg1")
		@Override
		public ValuationTradeInformation.ValuationTradeInformationBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
			this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
			return this;
		}
		
		@RosettaAttribute("nextFloatingReferenceResetDateLeg2")
		@RuneAttribute("nextFloatingReferenceResetDateLeg2")
		@Override
		public ValuationTradeInformation.ValuationTradeInformationBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
			this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
			return this;
		}
		
		@Override
		public ValuationTradeInformation build() {
			return new ValuationTradeInformation.ValuationTradeInformationImpl(this);
		}
		
		@Override
		public ValuationTradeInformation.ValuationTradeInformationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ValuationTradeInformation.ValuationTradeInformationBuilder prune() {
			if (uniqueTradeIdentifier!=null && !uniqueTradeIdentifier.prune().hasData()) uniqueTradeIdentifier = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUniqueTradeIdentifier()!=null && getUniqueTradeIdentifier().hasData()) return true;
			if (getAction()!=null) return true;
			if (getNextFloatingReferenceResetDateLeg1()!=null) return true;
			if (getNextFloatingReferenceResetDateLeg2()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ValuationTradeInformation.ValuationTradeInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ValuationTradeInformation.ValuationTradeInformationBuilder o = (ValuationTradeInformation.ValuationTradeInformationBuilder) other;
			
			merger.mergeRosetta(getUniqueTradeIdentifier(), o.getUniqueTradeIdentifier(), this::setUniqueTradeIdentifier);
			
			merger.mergeBasic(getAction(), o.getAction(), this::setAction);
			merger.mergeBasic(getNextFloatingReferenceResetDateLeg1(), o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1);
			merger.mergeBasic(getNextFloatingReferenceResetDateLeg2(), o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ValuationTradeInformation _that = getType().cast(o);
		
			if (!Objects.equals(uniqueTradeIdentifier, _that.getUniqueTradeIdentifier())) return false;
			if (!Objects.equals(action, _that.getAction())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) return false;
			if (!Objects.equals(nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uniqueTradeIdentifier != null ? uniqueTradeIdentifier.hashCode() : 0);
			_result = 31 * _result + (action != null ? action.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg1 != null ? nextFloatingReferenceResetDateLeg1.hashCode() : 0);
			_result = 31 * _result + (nextFloatingReferenceResetDateLeg2 != null ? nextFloatingReferenceResetDateLeg2.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ValuationTradeInformationBuilder {" +
				"uniqueTradeIdentifier=" + this.uniqueTradeIdentifier + ", " +
				"action=" + this.action + ", " +
				"nextFloatingReferenceResetDateLeg1=" + this.nextFloatingReferenceResetDateLeg1 + ", " +
				"nextFloatingReferenceResetDateLeg2=" + this.nextFloatingReferenceResetDateLeg2 +
			'}';
		}
	}
}
