package  drr.regulation.common.functions;

import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import static drr.regulation.common.PriceReportablePeriod.PriceReportablePeriodBuilder;

public class Create_ContinuousPriceScheduleImpl extends Create_ContinuousPriceSchedule {
    @Override
    protected List<PriceReportablePeriodBuilder> doEvaluate(List<? extends PriceReportablePeriod> reportablePeriods, Date endDate) {
        if (reportablePeriods == null || endDate == null) {
            return null;
        }
        LocalDate localEndDate = endDate.toLocalDate();

        // First sort based on start date
        List<? extends PriceReportablePeriod> sortedPeriods = reportablePeriods.stream().sorted(Comparator.comparing(PriceReportablePeriod::getPeriodEffectiveDate)).collect(Collectors.toList());

        return IntStream.range(0, sortedPeriods.size()).mapToObj(i -> {
            PriceReportablePeriod priceReportablePeriod = sortedPeriods.get(i);
            PriceReportablePeriodBuilder reportablePeriodBuilder = toBuilder(priceReportablePeriod);

            LocalDate computedEndDate;
            //This is the last reportable Period
            if (i == sortedPeriods.size() - 1) {
                computedEndDate = localEndDate;
            } else {
                computedEndDate = sortedPeriods.get(i + 1).getPeriodEffectiveDate().toLocalDate().minusDays(1);
            }

            if (priceReportablePeriod.getPeriodEndDate() == null || priceReportablePeriod.getPeriodEndDate().toLocalDate().isBefore(localEndDate)) {
                reportablePeriodBuilder.setPeriodEndDate(Date.of(computedEndDate));
            }
            return reportablePeriodBuilder;
        }).collect(Collectors.toList());
    }
}
