package drr.regulation.common.functions;

import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_AssetClass_Equity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.qualification.functions.Qualify_AssetClass_InterestRate;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import javax.inject.Inject;


@ImplementedBy(GetAssetClass.GetAssetClassDefault.class)
public abstract class GetAssetClass implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;
	@Inject protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;
	@Inject protected Qualify_AssetClass_InterestRate qualify_AssetClass_InterestRate;

	/**
	* @param economicTerms 
	* @return assetClass 
	*/
	public String evaluate(EconomicTerms economicTerms) {
		String assetClass = doEvaluate(economicTerms);
		
		return assetClass;
	}

	protected abstract String doEvaluate(EconomicTerms economicTerms);

	public static class GetAssetClassDefault extends GetAssetClass {
		@Override
		protected String doEvaluate(EconomicTerms economicTerms) {
			String assetClass = null;
			return assignOutput(assetClass, economicTerms);
		}
		
		protected String assignOutput(String assetClass, EconomicTerms economicTerms) {
			final Boolean boolean0 = qualify_AssetClass_InterestRate.evaluate(economicTerms);
			if ((boolean0 == null ? false : boolean0)) {
				assetClass = "INTR";
			} else {
				final Boolean boolean1 = qualify_AssetClass_Credit.evaluate(economicTerms);
				if ((boolean1 == null ? false : boolean1)) {
					assetClass = "CRDT";
				} else {
					final Boolean boolean2 = qualify_AssetClass_Equity.evaluate(economicTerms);
					if ((boolean2 == null ? false : boolean2)) {
						assetClass = "EQUI";
					} else {
						final Boolean boolean3 = qualify_AssetClass_Commodity.evaluate(economicTerms);
						if ((boolean3 == null ? false : boolean3)) {
							assetClass = "COMM";
						} else {
							final Boolean boolean4 = qualify_AssetClass_ForeignExchange.evaluate(economicTerms);
							if ((boolean4 == null ? false : boolean4)) {
								assetClass = "CURR";
							} else {
								assetClass = null;
							}
						}
					}
				}
			}
			
			return assetClass;
		}
	}
}
