package drr.regulation.common.functions;

import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_BaseProduct_CrossCurrency;
import cdm.product.qualification.functions.Qualify_BaseProduct_EquitySwap;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.qualification.functions.Qualify_BaseProduct_Inflation;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_EquityForward_PriceReturnBasicPerformance_Basket;
import cdm.product.qualification.functions.Qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex;
import cdm.product.qualification.functions.Qualify_EquityForward_PriceReturnBasicPerformance_SingleName;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDF;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Spot_Forward;
import cdm.product.qualification.functions.Qualify_InterestRate_CapFloor;
import cdm.product.qualification.functions.Qualify_InterestRate_Forward_Debt;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_Basis_YearOn_Year;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_Basis_ZeroCoupon;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year;
import cdm.product.qualification.functions.Qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import java.util.Arrays;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetContractType.GetContractTypeDefault.class)
public abstract class GetContractType implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsCommodityForward isCommodityForward;
	@Inject protected IsCommoditySwaption isCommoditySwaption;
	@Inject protected IsCreditSwaption isCreditSwaption;
	@Inject protected IsFRA isFRA;
	@Inject protected IsFXSwap isFXSwap;
	@Inject protected IsIRSwaption isIRSwaption;
	@Inject protected IsProductETD isProductETD;
	@Inject protected IsSingleCommodityPayoutProduct isSingleCommodityPayoutProduct;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
	@Inject protected Qualify_BaseProduct_CrossCurrency qualify_BaseProduct_CrossCurrency;
	@Inject protected Qualify_BaseProduct_EquitySwap qualify_BaseProduct_EquitySwap;
	@Inject protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
	@Inject protected Qualify_BaseProduct_Inflation qualify_BaseProduct_Inflation;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_EquityForward_PriceReturnBasicPerformance_Basket qualify_EquityForward_PriceReturnBasicPerformance_Basket;
	@Inject protected Qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex;
	@Inject protected Qualify_EquityForward_PriceReturnBasicPerformance_SingleName qualify_EquityForward_PriceReturnBasicPerformance_SingleName;
	@Inject protected Qualify_ForeignExchange_NDF qualify_ForeignExchange_NDF;
	@Inject protected Qualify_ForeignExchange_Spot_Forward qualify_ForeignExchange_Spot_Forward;
	@Inject protected Qualify_InterestRate_CapFloor qualify_InterestRate_CapFloor;
	@Inject protected Qualify_InterestRate_Forward_Debt qualify_InterestRate_Forward_Debt;
	@Inject protected Qualify_InterestRate_InflationSwap_Basis_YearOn_Year qualify_InterestRate_InflationSwap_Basis_YearOn_Year;
	@Inject protected Qualify_InterestRate_InflationSwap_Basis_ZeroCoupon qualify_InterestRate_InflationSwap_Basis_ZeroCoupon;
	@Inject protected Qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year;
	@Inject protected Qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon;

	/**
	* @param reportableEvent 
	* @return contractType 
	*/
	public String evaluate(ReportableEvent reportableEvent) {
		String contractType = doEvaluate(reportableEvent);
		
		return contractType;
	}

	protected abstract String doEvaluate(ReportableEvent reportableEvent);

	public static class GetContractTypeDefault extends GetContractType {
		@Override
		protected String doEvaluate(ReportableEvent reportableEvent) {
			String contractType = null;
			return assignOutput(contractType, reportableEvent);
		}
		
		protected String assignOutput(String contractType, ReportableEvent reportableEvent) {
			final MapperS<Product> thenArg = MapperS.of(productForEvent.evaluate(reportableEvent));
			contractType = thenArg
				.mapSingleToItem(item -> {
					final Boolean _boolean = isFRA.evaluate(item.get());
					if ((_boolean == null ? false : _boolean)) {
						return MapperS.of("FRAS");
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_Spot_Forward.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_ForeignExchange_NDF.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isSingleCommodityPayoutProduct.evaluate(item.get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCommodityForward.evaluate(item.get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_InterestRate_Forward_Debt.evaluate(economicTermsForProduct.evaluate(item.get()))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_EquityForward_PriceReturnBasicPerformance_SingleIndex.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_EquityForward_PriceReturnBasicPerformance_SingleName.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_EquityForward_PriceReturnBasicPerformance_Basket.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))))).getOrDefault(false)) {
						return MapperS.of("FORW");
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(isIRSwaption.evaluate(item.get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCreditSwaption.evaluate(item.get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isCommoditySwaption.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of("SWPT");
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(qualify_InterestRate_CapFloor.evaluate(economicTermsForProduct.evaluate(item.get())))).orNullSafe(onlyExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("optionPayout"))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isProductETD.evaluate(item.get())))).getOrDefault(false)) {
						return MapperS.of("OPTN");
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(qualify_BaseProduct_IRSwap.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get()))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_BaseProduct_Inflation.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_BaseProduct_CrossCurrency.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_InterestRate_InflationSwap_FixedFloat_YearOn_Year.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_InterestRate_InflationSwap_FixedFloat_ZeroCoupon.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_InterestRate_InflationSwap_Basis_YearOn_Year.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_InterestRate_InflationSwap_Basis_ZeroCoupon.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_AssetClass_Credit.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_BaseProduct_EquitySwap.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).get())))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(isFXSwap.evaluate(item.get())))).orNullSafe(onlyExists(item.<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("performancePayout"))).getOrDefault(false)) {
						return MapperS.of("SWAP");
					}
					if (ComparisonResult.ofNullSafe(MapperS.of(isProductETD.evaluate(item.get()))).andNullSafe(onlyExists(MapperS.of(economicTermsForProduct.evaluate(item.get())).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("forwardPayout"))).getOrDefault(false)) {
						return MapperS.of("FUTR");
					}
					return MapperS.of("OTHR");
				}).get();
			
			return contractType;
		}
	}
}
