package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.PriceNotationEnum;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetNotationEnum.GetNotationEnumDefault.class)
public abstract class GetNotationEnum implements RosettaFunction {

	/**
	* @param notationString 
	* @return notationEnum 
	*/
	public PriceNotationEnum evaluate(String notationString) {
		PriceNotationEnum notationEnum = doEvaluate(notationString);
		
		return notationEnum;
	}

	protected abstract PriceNotationEnum doEvaluate(String notationString);

	public static class GetNotationEnumDefault extends GetNotationEnum {
		@Override
		protected PriceNotationEnum doEvaluate(String notationString) {
			PriceNotationEnum notationEnum = null;
			return assignOutput(notationEnum, notationString);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum notationEnum, String notationString) {
			if (areEqual(MapperS.of(notationString), MapperS.of("1"), CardinalityOperator.All).getOrDefault(false)) {
				notationEnum = PriceNotationEnum.MONETARY;
			} else if (areEqual(MapperS.of(notationString), MapperS.of("2"), CardinalityOperator.All).getOrDefault(false)) {
				notationEnum = PriceNotationEnum.PERCENTAGE;
			} else if (areEqual(MapperS.of(notationString), MapperS.of("3"), CardinalityOperator.All).getOrDefault(false)) {
				notationEnum = PriceNotationEnum.DECIMAL;
			} else if (areEqual(MapperS.of(notationString), MapperS.of("4"), CardinalityOperator.All).getOrDefault(false)) {
				notationEnum = PriceNotationEnum.BASIS;
			} else {
				notationEnum = null;
			}
			
			return notationEnum;
		}
	}
}
