package drr.regulation.common.functions;

import cdm.base.datetime.DateRange;
import cdm.base.math.DatedValue;
import cdm.observable.asset.PriceSchedule;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.CalculationSchedule;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.SchedulePeriod;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.ReportableEvent;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(GetReportablePricePeriod.GetReportablePricePeriodDefault.class)
public abstract class GetReportablePricePeriod implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_Price_Monetary contract_Price_Monetary;
	@Inject protected Create_PriceReportablePeriod create_PriceReportablePeriod;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_Commodity_Forward qualify_Commodity_Forward;
	@Inject protected Qualify_Commodity_Option qualify_Commodity_Option;
	@Inject protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
	@Inject protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
	@Inject protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;

	/**
	* @param reportableEvent 
	* @return reportablePeriod 
	*/
	public List<? extends PriceReportablePeriod> evaluate(ReportableEvent reportableEvent) {
		List<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriodBuilder = doEvaluate(reportableEvent);
		
		final List<? extends PriceReportablePeriod> reportablePeriod;
		if (reportablePeriodBuilder == null) {
			reportablePeriod = null;
		} else {
			reportablePeriod = reportablePeriodBuilder.stream().map(PriceReportablePeriod::build).collect(Collectors.toList());
			objectValidator.validate(PriceReportablePeriod.class, reportablePeriod);
		}
		
		return reportablePeriod;
	}

	protected abstract List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent);

	protected abstract MapperS<? extends PriceSchedule> priceSchedule(ReportableEvent reportableEvent);

	protected abstract MapperS<PriceNotationEnum> priceNotation(ReportableEvent reportableEvent);

	public static class GetReportablePricePeriodDefault extends GetReportablePricePeriod {
		@Override
		protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> doEvaluate(ReportableEvent reportableEvent) {
			List<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriod = new ArrayList<>();
			return assignOutput(reportablePeriod, reportableEvent);
		}
		
		protected List<PriceReportablePeriod.PriceReportablePeriodBuilder> assignOutput(List<PriceReportablePeriod.PriceReportablePeriodBuilder> reportablePeriod, ReportableEvent reportableEvent) {
			if (exists(customizedSchedule(reportableEvent)).getOrDefault(false)) {
				reportablePeriod.addAll(toBuilder(priceSchedule(reportableEvent).<DatedValue>mapC("getDatedValue", _priceSchedule -> _priceSchedule.getDatedValue())
					.mapItem(pricePeriod -> {
						final MapperC<SchedulePeriod> thenArg0 = customizedSchedule(reportableEvent).<SchedulePeriod>mapC("getSchedulePeriod", calculationSchedule -> calculationSchedule.getSchedulePeriod())
							.filterItemNullSafe(customPeriod -> areEqual(pricePeriod.<Date>map("getDate", datedValue -> datedValue.getDate()), customPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()), CardinalityOperator.All).get());
						final MapperS<SchedulePeriod> thenArg1 = MapperS.of(thenArg0.get());
						return thenArg1
							.mapSingleToItem(matchingCustomPeriod -> MapperS.of(create_PriceReportablePeriod.evaluate(pricePeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).get(), matchingCustomPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getStartDate", dateRange -> dateRange.getStartDate()).get(), matchingCustomPeriod.<DateRange>map("getCalculationPeriod", schedulePeriod -> schedulePeriod.getCalculationPeriod()).<Date>map("getEndDate", dateRange -> dateRange.getEndDate()).get(), priceNotation(reportableEvent).get())));
					}).getMulti()));
			} else {
				reportablePeriod.addAll(toBuilder(priceSchedule(reportableEvent).<DatedValue>mapC("getDatedValue", _priceSchedule -> _priceSchedule.getDatedValue())
					.mapItem(pricePeriod -> MapperS.of(create_PriceReportablePeriod.evaluate(pricePeriod.<BigDecimal>map("getValue", datedValue -> datedValue.getValue()).get(), pricePeriod.<Date>map("getDate", datedValue -> datedValue.getDate()).get(), null, priceNotation(reportableEvent).get()))).getMulti()));
			}
			
			return Optional.ofNullable(reportablePeriod)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends CalculationSchedule> customizedSchedule(ReportableEvent reportableEvent) {
			if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_FixedFloat.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swap_Basis.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)))))).getOrDefault(false)) {
				return MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<CommodityPayout>mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).<CalculationSchedule>map("getSchedule", commodityPayout -> commodityPayout.getSchedule())
					.first();
			}
			if (ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Option.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))))).orNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_Commodity_Swaption.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)))))).getOrDefault(false)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<CalculationSchedule>map("getSchedule", optionPayout -> optionPayout.getSchedule());
			}
			final Boolean _boolean = qualify_Commodity_Forward.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent)));
			if ((_boolean == null ? false : _boolean)) {
				return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(reportableEvent))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()).<CalculationSchedule>map("getSchedule", forwardPayout -> forwardPayout.getSchedule());
			}
			return MapperS.<CalculationSchedule>ofNull();
		}
		
		@Override
		protected MapperS<? extends PriceSchedule> priceSchedule(ReportableEvent reportableEvent) {
			return MapperS.of(MapperC.of(contract_Price_Monetary.evaluate(reportableEvent)).get());
		}
		
		@Override
		protected MapperS<PriceNotationEnum> priceNotation(ReportableEvent reportableEvent) {
			return MapperS.of(getPriceNotation.evaluate(priceSchedule(reportableEvent).get()));
		}
	}
}
