package drr.regulation.common.functions;

import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.datetime.functions.DateDifference;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PeriodCalculation.PeriodCalculationDefault.class)
public abstract class PeriodCalculation implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected DateDifference dateDifference;

	/**
	* @param period 
	* @param periodMultiplier 
	* @param effectiveDate 
	* @param terminationDate 
	* @return result 
	*/
	public Integer evaluate(PeriodExtendedEnum period, Integer periodMultiplier, Date effectiveDate, Date terminationDate) {
		Integer result = doEvaluate(period, periodMultiplier, effectiveDate, terminationDate);
		
		return result;
	}

	protected abstract Integer doEvaluate(PeriodExtendedEnum period, Integer periodMultiplier, Date effectiveDate, Date terminationDate);

	public static class PeriodCalculationDefault extends PeriodCalculation {
		@Override
		protected Integer doEvaluate(PeriodExtendedEnum period, Integer periodMultiplier, Date effectiveDate, Date terminationDate) {
			Integer result = null;
			return assignOutput(result, period, periodMultiplier, effectiveDate, terminationDate);
		}
		
		protected Integer assignOutput(Integer result, PeriodExtendedEnum period, Integer periodMultiplier, Date effectiveDate, Date terminationDate) {
			if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.D), CardinalityOperator.All).getOrDefault(false)) {
				result = periodMultiplier;
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.W), CardinalityOperator.All).getOrDefault(false)) {
				result = MapperMaths.<Integer, Integer, Integer>multiply(MapperS.of(periodMultiplier), MapperS.of(7)).get();
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.M), CardinalityOperator.All).getOrDefault(false)) {
				result = MapperMaths.<Integer, Integer, Integer>multiply(MapperS.of(periodMultiplier), MapperS.of(30)).get();
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.Y), CardinalityOperator.All).getOrDefault(false)) {
				result = MapperMaths.<Integer, Integer, Integer>multiply(MapperS.of(periodMultiplier), MapperS.of(365)).get();
			} else if (areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.T), CardinalityOperator.All).orNullSafe(areEqual(MapperS.of(period), MapperS.of(PeriodExtendedEnum.C), CardinalityOperator.All)).getOrDefault(false)) {
				result = MapperMaths.<Integer, Integer, Integer>multiply(MapperS.of(periodMultiplier), MapperS.of(dateDifference.evaluate(effectiveDate, terminationDate))).get();
			} else {
				result = null;
			}
			
			return result;
		}
	}
}
