package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.esma.emir.refit.trade.PriceScheduleReport;
import drr.regulation.esma.emir.refit.trade.functions.EUEMIRReportablePricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(ContractPriceScheduleRule.ContractPriceScheduleRuleDefault.class)
public abstract class ContractPriceScheduleRule implements ReportFunction<TransactionReportInstruction, List<? extends PriceScheduleReport>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected EUEMIRReportablePricePeriod eUEMIRReportablePricePeriod;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected PriceInEffectBetweenTheUnadjustedEffectiveAndEndDateFormatMonetaryRule priceInEffectBetweenTheUnadjustedEffectiveAndEndDateFormatMonetaryRule;
	@Inject protected PriceInEffectBetweenTheUnadjustedEffectiveAndEndDatePercentageRule priceInEffectBetweenTheUnadjustedEffectiveAndEndDatePercentageRule;
	@Inject protected UnadjustedEffectiveDateOfThePriceRule unadjustedEffectiveDateOfThePriceRule;
	@Inject protected UnadjustedEndDateOfThePriceRule unadjustedEndDateOfThePriceRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends PriceScheduleReport> evaluate(TransactionReportInstruction input) {
		List<PriceScheduleReport.PriceScheduleReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends PriceScheduleReport> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(PriceScheduleReport::build).collect(Collectors.toList());
			objectValidator.validate(PriceScheduleReport.class, output);
		}
		
		return output;
	}

	protected abstract List<PriceScheduleReport.PriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class ContractPriceScheduleRuleDefault extends ContractPriceScheduleRule {
		@Override
		protected List<PriceScheduleReport.PriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<PriceScheduleReport.PriceScheduleReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<PriceScheduleReport.PriceScheduleReportBuilder> assignOutput(List<PriceScheduleReport.PriceScheduleReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperC<PriceReportablePeriod> thenArg1 = thenArg0
				.mapSingleToList(item -> MapperC.<PriceReportablePeriod>of(eUEMIRReportablePricePeriod.evaluate(item.get())));
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(PriceScheduleReport.builder()
					.setEffectiveDate(unadjustedEffectiveDateOfThePriceRule.evaluate(item.get()))
					.setEndDate(unadjustedEndDateOfThePriceRule.evaluate(item.get()))
					.setPriceMonetary(priceInEffectBetweenTheUnadjustedEffectiveAndEndDateFormatMonetaryRule.evaluate(item.get()))
					.setPricePercentage(priceInEffectBetweenTheUnadjustedEffectiveAndEndDatePercentageRule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
