package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalQuantityScheduleEffectiveDateRule;
import javax.inject.Inject;


@ImplementedBy(EffectiveDateOfTheNotionalQuantityOfLeg2Rule.EffectiveDateOfTheNotionalQuantityOfLeg2RuleDefault.class)
public abstract class EffectiveDateOfTheNotionalQuantityOfLeg2Rule implements ReportFunction<QuantityReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalQuantityScheduleEffectiveDateRule cDENotionalQuantityScheduleEffectiveDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class EffectiveDateOfTheNotionalQuantityOfLeg2RuleDefault extends EffectiveDateOfTheNotionalQuantityOfLeg2Rule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = cDENotionalQuantityScheduleEffectiveDateRule.evaluate(input);
			
			return output;
		}
	}
}
