package drr.regulation.esma.emir.refit.trade.reports;

import cdm.base.math.RoundingDirectionEnum;
import cdm.base.math.functions.RoundToPrecision;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.IsOtherPayment;
import drr.standards.iosco.cde.reports.CDEOtherPaymentAmountRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(OtherPaymentAmountRule.OtherPaymentAmountRuleDefault.class)
public abstract class OtherPaymentAmountRule implements ReportFunction<TransferState, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEOtherPaymentAmountRule cDEOtherPaymentAmountRule;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected IsOtherPayment isOtherPayment;
	@Inject protected RoundToPrecision roundToPrecision;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransferState input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransferState input);

	public static class OtherPaymentAmountRuleDefault extends OtherPaymentAmountRule {
		@Override
		protected BigDecimal doEvaluate(TransferState input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransferState input) {
			final MapperS<TransferState> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isOtherPayment.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(cDEOtherPaymentAmountRule.evaluate(item.get())));
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(item -> MapperS.of(roundToPrecision.evaluate(item.get(), 5, RoundingDirectionEnum.NEAREST)));
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
