package drr.regulation.esma.emir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEStrikePriceScheduleAmountFormatPercentageRule;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(StrikePriceInEffectOnAssociatedEffectiveDatePercentageRule.StrikePriceInEffectOnAssociatedEffectiveDatePercentageRuleDefault.class)
public abstract class StrikePriceInEffectOnAssociatedEffectiveDatePercentageRule implements ReportFunction<PriceReportablePeriod, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceScheduleAmountFormatPercentageRule cDEStrikePriceScheduleAmountFormatPercentageRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(PriceReportablePeriod input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(PriceReportablePeriod input);

	public static class StrikePriceInEffectOnAssociatedEffectiveDatePercentageRuleDefault extends StrikePriceInEffectOnAssociatedEffectiveDatePercentageRule {
		@Override
		protected BigDecimal doEvaluate(PriceReportablePeriod input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, PriceReportablePeriod input) {
			output = cDEStrikePriceScheduleAmountFormatPercentageRule.evaluate(input);
			
			return output;
		}
	}
}
