package drr.regulation.esma.emir.refit.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.DeliveryReport;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkNumber;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.Optional.empty;
import static java.util.Optional.of;
import static java.util.stream.Collectors.toList;

public class DeliveryReportTypeFormatValidator implements Validator<DeliveryReport> {

	private List<ComparisonResult> getComparisonResults(DeliveryReport o) {
		return Lists.<ComparisonResult>newArrayList(
				checkNumber("deliveryCapacity", o.getDeliveryCapacity(), of(20), of(19), empty(), empty()), 
				checkNumber("priceTimeIntervalQuantity", o.getPriceTimeIntervalQuantity(), of(20), of(19), empty(), empty())
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, DeliveryReport o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("DeliveryReport", ValidationResult.ValidationType.TYPE_FORMAT, "DeliveryReport", path, "", res.getError());
				}
				return success("DeliveryReport", ValidationResult.ValidationType.TYPE_FORMAT, "DeliveryReport", path, "");
			})
			.collect(toList());
	}

}
