package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.functions.IsVRAllowedForActionType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("ESMAEMIRTransactionReportEMIR_VR_2034_01")
@ImplementedBy(ESMAEMIRTransactionReportEMIR_VR_2034_01.Default.class)
public interface ESMAEMIRTransactionReportEMIR_VR_2034_01 extends Validator<ESMAEMIRTransactionReport> {
	
	String NAME = "ESMAEMIRTransactionReportEMIR_VR_2034_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then ([\"ISDA\", \"CDEA\", \"EUMA\", \"FPCA\", \"FMAT\", \"DERV\", \"CMOP\", \"CHMA\", \"IDMA\", \"EFMA\", \"GMRA\", \"GMSL\", \"BIAG\", \"OTHR\"] any = masterAgreementType)";
	
	class Default implements ESMAEMIRTransactionReportEMIR_VR_2034_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(eSMAEMIRTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "ESMAEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(eSMAEMIRTransactionReport).<String>map("getActionType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					return areEqual(MapperC.<String>of(MapperS.of("ISDA"), MapperS.of("CDEA"), MapperS.of("EUMA"), MapperS.of("FPCA"), MapperS.of("FMAT"), MapperS.of("DERV"), MapperS.of("CMOP"), MapperS.of("CHMA"), MapperS.of("IDMA"), MapperS.of("EFMA"), MapperS.of("GMRA"), MapperS.of("GMSL"), MapperS.of("BIAG"), MapperS.of("OTHR")), MapperS.of(eSMAEMIRTransactionReport).<String>map("getMasterAgreementType", _eSMAEMIRTransactionReport -> _eSMAEMIRTransactionReport.getMasterAgreementType()), CardinalityOperator.Any);
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ESMAEMIRTransactionReportEMIR_VR_2034_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ESMAEMIRTransactionReport eSMAEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
