package drr.regulation.esma.emir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.esma.emir.refit.trade.PriceScheduleReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("PriceScheduleReportMonetaryOrPercentage")
@ImplementedBy(PriceScheduleReportMonetaryOrPercentage.Default.class)
public interface PriceScheduleReportMonetaryOrPercentage extends Validator<PriceScheduleReport> {
	
	String NAME = "PriceScheduleReportMonetaryOrPercentage";
	String DEFINITION = "optional choice priceMonetary, pricePercentage";
	
	class Default implements PriceScheduleReportMonetaryOrPercentage {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceScheduleReport priceScheduleReport) {
			ComparisonResult result = executeDataRule(priceScheduleReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PriceScheduleReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "PriceScheduleReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PriceScheduleReport priceScheduleReport) {
			try {
				return choice(MapperS.of(priceScheduleReport), Arrays.asList("priceMonetary", "pricePercentage"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PriceScheduleReportMonetaryOrPercentage {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceScheduleReport priceScheduleReport) {
			return Collections.emptyList();
		}
	}
}
