package drr.regulation.esma.emir.refit.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.esma.emir.refit.trade.DeliveryReport;
import iso20022.auth030.esma.DurationType1Code;
import iso20022.auth030.esma.EnergyQuantityUnit2Code;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class DeliveryReportOnlyExistsValidator implements ValidatorWithArg<DeliveryReport, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends DeliveryReport> ValidationResult<DeliveryReport> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("deliveryStartTime", ExistenceChecker.isSet((LocalTime) o.getDeliveryStartTime()))
				.put("deliveryEndTime", ExistenceChecker.isSet((LocalTime) o.getDeliveryEndTime()))
				.put("deliveryStartDate", ExistenceChecker.isSet((Date) o.getDeliveryStartDate()))
				.put("deliveryEndDate", ExistenceChecker.isSet((Date) o.getDeliveryEndDate()))
				.put("duration", ExistenceChecker.isSet((DurationType1Code) o.getDuration()))
				.put("daysOfTheWeek", ExistenceChecker.isSet((List<String>) o.getDaysOfTheWeek()))
				.put("deliveryCapacity", ExistenceChecker.isSet((BigDecimal) o.getDeliveryCapacity()))
				.put("quantityUnit", ExistenceChecker.isSet((EnergyQuantityUnit2Code) o.getQuantityUnit()))
				.put("priceTimeIntervalQuantity", ExistenceChecker.isSet((BigDecimal) o.getPriceTimeIntervalQuantity()))
				.put("currencyOfThePriceTimeIntervalQuantity", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getCurrencyOfThePriceTimeIntervalQuantity()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("DeliveryReport", ValidationResult.ValidationType.ONLY_EXISTS, "DeliveryReport", path, "");
		}
		return failure("DeliveryReport", ValidationResult.ValidationType.ONLY_EXISTS, "DeliveryReport", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
