package drr.regulation.esma.emir.refit.trade.validation.exists;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.esma.emir.refit.trade.PriceAndNotation;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class PriceAndNotationOnlyExistsValidator implements ValidatorWithArg<PriceAndNotation, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends PriceAndNotation> ValidationResult<PriceAndNotation> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("priceMonetary", ExistenceChecker.isSet((BigDecimal) o.getPriceMonetary()))
				.put("pricePercentage", ExistenceChecker.isSet((BigDecimal) o.getPricePercentage()))
				.put("priceCurrency", ExistenceChecker.isSet((ISOCurrencyCodeEnum) o.getPriceCurrency()))
				.put("priceNotation", ExistenceChecker.isSet((PriceNotationEnum) o.getPriceNotation()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("PriceAndNotation", ValidationResult.ValidationType.ONLY_EXISTS, "PriceAndNotation", path, "");
		}
		return failure("PriceAndNotation", ValidationResult.ValidationType.ONLY_EXISTS, "PriceAndNotation", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
