package drr.regulation.fca.ukemir.refit.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.fca.ukemir.refit.trade.meta.ExecutionAgentMeta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.58.0
 */
@RosettaDataType(value="ExecutionAgent", builder=ExecutionAgent.ExecutionAgentBuilderImpl.class, version="5.58.0")
@RuneDataType(value="ExecutionAgent", model="drr", builder=ExecutionAgent.ExecutionAgentBuilderImpl.class, version="5.58.0")
public interface ExecutionAgent extends RosettaModelObject {

	ExecutionAgentMeta metaData = new ExecutionAgentMeta();

	/*********************** Getter Methods  ***********************/
	String getExecutionAgentReportingParty();
	String getExecutionAgentReportingCounterparty();

	/*********************** Build Methods  ***********************/
	ExecutionAgent build();
	
	ExecutionAgent.ExecutionAgentBuilder toBuilder();
	
	static ExecutionAgent.ExecutionAgentBuilder builder() {
		return new ExecutionAgent.ExecutionAgentBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ExecutionAgent> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ExecutionAgent> getType() {
		return ExecutionAgent.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("executionAgentReportingParty"), String.class, getExecutionAgentReportingParty(), this);
		processor.processBasic(path.newSubPath("executionAgentReportingCounterparty"), String.class, getExecutionAgentReportingCounterparty(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface ExecutionAgentBuilder extends ExecutionAgent, RosettaModelObjectBuilder {
		ExecutionAgent.ExecutionAgentBuilder setExecutionAgentReportingParty(String executionAgentReportingParty);
		ExecutionAgent.ExecutionAgentBuilder setExecutionAgentReportingCounterparty(String executionAgentReportingCounterparty);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("executionAgentReportingParty"), String.class, getExecutionAgentReportingParty(), this);
			processor.processBasic(path.newSubPath("executionAgentReportingCounterparty"), String.class, getExecutionAgentReportingCounterparty(), this);
		}
		

		ExecutionAgent.ExecutionAgentBuilder prune();
	}

	/*********************** Immutable Implementation of ExecutionAgent  ***********************/
	class ExecutionAgentImpl implements ExecutionAgent {
		private final String executionAgentReportingParty;
		private final String executionAgentReportingCounterparty;
		
		protected ExecutionAgentImpl(ExecutionAgent.ExecutionAgentBuilder builder) {
			this.executionAgentReportingParty = builder.getExecutionAgentReportingParty();
			this.executionAgentReportingCounterparty = builder.getExecutionAgentReportingCounterparty();
		}
		
		@Override
		@RosettaAttribute("executionAgentReportingParty")
		@RuneAttribute("executionAgentReportingParty")
		public String getExecutionAgentReportingParty() {
			return executionAgentReportingParty;
		}
		
		@Override
		@RosettaAttribute("executionAgentReportingCounterparty")
		@RuneAttribute("executionAgentReportingCounterparty")
		public String getExecutionAgentReportingCounterparty() {
			return executionAgentReportingCounterparty;
		}
		
		@Override
		public ExecutionAgent build() {
			return this;
		}
		
		@Override
		public ExecutionAgent.ExecutionAgentBuilder toBuilder() {
			ExecutionAgent.ExecutionAgentBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ExecutionAgent.ExecutionAgentBuilder builder) {
			ofNullable(getExecutionAgentReportingParty()).ifPresent(builder::setExecutionAgentReportingParty);
			ofNullable(getExecutionAgentReportingCounterparty()).ifPresent(builder::setExecutionAgentReportingCounterparty);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ExecutionAgent _that = getType().cast(o);
		
			if (!Objects.equals(executionAgentReportingParty, _that.getExecutionAgentReportingParty())) return false;
			if (!Objects.equals(executionAgentReportingCounterparty, _that.getExecutionAgentReportingCounterparty())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (executionAgentReportingParty != null ? executionAgentReportingParty.hashCode() : 0);
			_result = 31 * _result + (executionAgentReportingCounterparty != null ? executionAgentReportingCounterparty.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ExecutionAgent {" +
				"executionAgentReportingParty=" + this.executionAgentReportingParty + ", " +
				"executionAgentReportingCounterparty=" + this.executionAgentReportingCounterparty +
			'}';
		}
	}

	/*********************** Builder Implementation of ExecutionAgent  ***********************/
	class ExecutionAgentBuilderImpl implements ExecutionAgent.ExecutionAgentBuilder {
	
		protected String executionAgentReportingParty;
		protected String executionAgentReportingCounterparty;
		
		@Override
		@RosettaAttribute("executionAgentReportingParty")
		@RuneAttribute("executionAgentReportingParty")
		public String getExecutionAgentReportingParty() {
			return executionAgentReportingParty;
		}
		
		@Override
		@RosettaAttribute("executionAgentReportingCounterparty")
		@RuneAttribute("executionAgentReportingCounterparty")
		public String getExecutionAgentReportingCounterparty() {
			return executionAgentReportingCounterparty;
		}
		
		@RosettaAttribute("executionAgentReportingParty")
		@RuneAttribute("executionAgentReportingParty")
		@Override
		public ExecutionAgent.ExecutionAgentBuilder setExecutionAgentReportingParty(String _executionAgentReportingParty) {
			this.executionAgentReportingParty = _executionAgentReportingParty == null ? null : _executionAgentReportingParty;
			return this;
		}
		
		@RosettaAttribute("executionAgentReportingCounterparty")
		@RuneAttribute("executionAgentReportingCounterparty")
		@Override
		public ExecutionAgent.ExecutionAgentBuilder setExecutionAgentReportingCounterparty(String _executionAgentReportingCounterparty) {
			this.executionAgentReportingCounterparty = _executionAgentReportingCounterparty == null ? null : _executionAgentReportingCounterparty;
			return this;
		}
		
		@Override
		public ExecutionAgent build() {
			return new ExecutionAgent.ExecutionAgentImpl(this);
		}
		
		@Override
		public ExecutionAgent.ExecutionAgentBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ExecutionAgent.ExecutionAgentBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getExecutionAgentReportingParty()!=null) return true;
			if (getExecutionAgentReportingCounterparty()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ExecutionAgent.ExecutionAgentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ExecutionAgent.ExecutionAgentBuilder o = (ExecutionAgent.ExecutionAgentBuilder) other;
			
			
			merger.mergeBasic(getExecutionAgentReportingParty(), o.getExecutionAgentReportingParty(), this::setExecutionAgentReportingParty);
			merger.mergeBasic(getExecutionAgentReportingCounterparty(), o.getExecutionAgentReportingCounterparty(), this::setExecutionAgentReportingCounterparty);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ExecutionAgent _that = getType().cast(o);
		
			if (!Objects.equals(executionAgentReportingParty, _that.getExecutionAgentReportingParty())) return false;
			if (!Objects.equals(executionAgentReportingCounterparty, _that.getExecutionAgentReportingCounterparty())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (executionAgentReportingParty != null ? executionAgentReportingParty.hashCode() : 0);
			_result = 31 * _result + (executionAgentReportingCounterparty != null ? executionAgentReportingCounterparty.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ExecutionAgentBuilder {" +
				"executionAgentReportingParty=" + this.executionAgentReportingParty + ", " +
				"executionAgentReportingCounterparty=" + this.executionAgentReportingCounterparty +
			'}';
		}
	}
}
