package drr.regulation.fca.ukemir.refit.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.fca.ukemir.refit.trade.meta.PriceScheduleReportMeta;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.58.0
 */
@RosettaDataType(value="PriceScheduleReport", builder=PriceScheduleReport.PriceScheduleReportBuilderImpl.class, version="5.58.0")
@RuneDataType(value="PriceScheduleReport", model="drr", builder=PriceScheduleReport.PriceScheduleReportBuilderImpl.class, version="5.58.0")
public interface PriceScheduleReport extends RosettaModelObject {

	PriceScheduleReportMeta metaData = new PriceScheduleReportMeta();

	/*********************** Getter Methods  ***********************/
	Date getEffectiveDate();
	Date getEndDate();
	BigDecimal getPriceMonetary();
	BigDecimal getPricePercentage();

	/*********************** Build Methods  ***********************/
	PriceScheduleReport build();
	
	PriceScheduleReport.PriceScheduleReportBuilder toBuilder();
	
	static PriceScheduleReport.PriceScheduleReportBuilder builder() {
		return new PriceScheduleReport.PriceScheduleReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PriceScheduleReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PriceScheduleReport> getType() {
		return PriceScheduleReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
		processor.processBasic(path.newSubPath("priceMonetary"), BigDecimal.class, getPriceMonetary(), this);
		processor.processBasic(path.newSubPath("pricePercentage"), BigDecimal.class, getPricePercentage(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PriceScheduleReportBuilder extends PriceScheduleReport, RosettaModelObjectBuilder {
		PriceScheduleReport.PriceScheduleReportBuilder setEffectiveDate(Date effectiveDate);
		PriceScheduleReport.PriceScheduleReportBuilder setEndDate(Date endDate);
		PriceScheduleReport.PriceScheduleReportBuilder setPriceMonetary(BigDecimal priceMonetary);
		PriceScheduleReport.PriceScheduleReportBuilder setPricePercentage(BigDecimal pricePercentage);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("endDate"), Date.class, getEndDate(), this);
			processor.processBasic(path.newSubPath("priceMonetary"), BigDecimal.class, getPriceMonetary(), this);
			processor.processBasic(path.newSubPath("pricePercentage"), BigDecimal.class, getPricePercentage(), this);
		}
		

		PriceScheduleReport.PriceScheduleReportBuilder prune();
	}

	/*********************** Immutable Implementation of PriceScheduleReport  ***********************/
	class PriceScheduleReportImpl implements PriceScheduleReport {
		private final Date effectiveDate;
		private final Date endDate;
		private final BigDecimal priceMonetary;
		private final BigDecimal pricePercentage;
		
		protected PriceScheduleReportImpl(PriceScheduleReport.PriceScheduleReportBuilder builder) {
			this.effectiveDate = builder.getEffectiveDate();
			this.endDate = builder.getEndDate();
			this.priceMonetary = builder.getPriceMonetary();
			this.pricePercentage = builder.getPricePercentage();
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		public BigDecimal getPriceMonetary() {
			return priceMonetary;
		}
		
		@Override
		@RosettaAttribute("pricePercentage")
		@RuneAttribute("pricePercentage")
		public BigDecimal getPricePercentage() {
			return pricePercentage;
		}
		
		@Override
		public PriceScheduleReport build() {
			return this;
		}
		
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder toBuilder() {
			PriceScheduleReport.PriceScheduleReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PriceScheduleReport.PriceScheduleReportBuilder builder) {
			ofNullable(getEffectiveDate()).ifPresent(builder::setEffectiveDate);
			ofNullable(getEndDate()).ifPresent(builder::setEndDate);
			ofNullable(getPriceMonetary()).ifPresent(builder::setPriceMonetary);
			ofNullable(getPricePercentage()).ifPresent(builder::setPricePercentage);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PriceScheduleReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			if (!Objects.equals(priceMonetary, _that.getPriceMonetary())) return false;
			if (!Objects.equals(pricePercentage, _that.getPricePercentage())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			_result = 31 * _result + (priceMonetary != null ? priceMonetary.hashCode() : 0);
			_result = 31 * _result + (pricePercentage != null ? pricePercentage.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PriceScheduleReport {" +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate + ", " +
				"priceMonetary=" + this.priceMonetary + ", " +
				"pricePercentage=" + this.pricePercentage +
			'}';
		}
	}

	/*********************** Builder Implementation of PriceScheduleReport  ***********************/
	class PriceScheduleReportBuilderImpl implements PriceScheduleReport.PriceScheduleReportBuilder {
	
		protected Date effectiveDate;
		protected Date endDate;
		protected BigDecimal priceMonetary;
		protected BigDecimal pricePercentage;
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public Date getEffectiveDate() {
			return effectiveDate;
		}
		
		@Override
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		public Date getEndDate() {
			return endDate;
		}
		
		@Override
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		public BigDecimal getPriceMonetary() {
			return priceMonetary;
		}
		
		@Override
		@RosettaAttribute("pricePercentage")
		@RuneAttribute("pricePercentage")
		public BigDecimal getPricePercentage() {
			return pricePercentage;
		}
		
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@RosettaAttribute("endDate")
		@RuneAttribute("endDate")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder setEndDate(Date _endDate) {
			this.endDate = _endDate == null ? null : _endDate;
			return this;
		}
		
		@RosettaAttribute("priceMonetary")
		@RuneAttribute("priceMonetary")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder setPriceMonetary(BigDecimal _priceMonetary) {
			this.priceMonetary = _priceMonetary == null ? null : _priceMonetary;
			return this;
		}
		
		@RosettaAttribute("pricePercentage")
		@RuneAttribute("pricePercentage")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder setPricePercentage(BigDecimal _pricePercentage) {
			this.pricePercentage = _pricePercentage == null ? null : _pricePercentage;
			return this;
		}
		
		@Override
		public PriceScheduleReport build() {
			return new PriceScheduleReport.PriceScheduleReportImpl(this);
		}
		
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getEffectiveDate()!=null) return true;
			if (getEndDate()!=null) return true;
			if (getPriceMonetary()!=null) return true;
			if (getPricePercentage()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PriceScheduleReport.PriceScheduleReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PriceScheduleReport.PriceScheduleReportBuilder o = (PriceScheduleReport.PriceScheduleReportBuilder) other;
			
			
			merger.mergeBasic(getEffectiveDate(), o.getEffectiveDate(), this::setEffectiveDate);
			merger.mergeBasic(getEndDate(), o.getEndDate(), this::setEndDate);
			merger.mergeBasic(getPriceMonetary(), o.getPriceMonetary(), this::setPriceMonetary);
			merger.mergeBasic(getPricePercentage(), o.getPricePercentage(), this::setPricePercentage);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PriceScheduleReport _that = getType().cast(o);
		
			if (!Objects.equals(effectiveDate, _that.getEffectiveDate())) return false;
			if (!Objects.equals(endDate, _that.getEndDate())) return false;
			if (!Objects.equals(priceMonetary, _that.getPriceMonetary())) return false;
			if (!Objects.equals(pricePercentage, _that.getPricePercentage())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (effectiveDate != null ? effectiveDate.hashCode() : 0);
			_result = 31 * _result + (endDate != null ? endDate.hashCode() : 0);
			_result = 31 * _result + (priceMonetary != null ? priceMonetary.hashCode() : 0);
			_result = 31 * _result + (pricePercentage != null ? pricePercentage.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PriceScheduleReportBuilder {" +
				"effectiveDate=" + this.effectiveDate + ", " +
				"endDate=" + this.endDate + ", " +
				"priceMonetary=" + this.priceMonetary + ", " +
				"pricePercentage=" + this.pricePercentage +
			'}';
		}
	}
}
