package drr.regulation.fca.ukemir.refit.trade.meta;

import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.fca.ukemir.refit.trade.SpreadOfLeg1;
import drr.regulation.fca.ukemir.refit.trade.validation.SpreadOfLeg1TypeFormatValidator;
import drr.regulation.fca.ukemir.refit.trade.validation.SpreadOfLeg1Validator;
import drr.regulation.fca.ukemir.refit.trade.validation.datarule.SpreadOfLeg1MonetaryOrPercentageOrBasis;
import drr.regulation.fca.ukemir.refit.trade.validation.exists.SpreadOfLeg1OnlyExistsValidator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.58.0
 */
@RosettaMeta(model=SpreadOfLeg1.class)
public class SpreadOfLeg1Meta implements RosettaMetaData<SpreadOfLeg1> {

	@Override
	public List<Validator<? super SpreadOfLeg1>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<SpreadOfLeg1>create(SpreadOfLeg1MonetaryOrPercentageOrBasis.class)
		);
	}
	
	@Override
	public List<Function<? super SpreadOfLeg1, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super SpreadOfLeg1> validator(ValidatorFactory factory) {
		return factory.<SpreadOfLeg1>create(SpreadOfLeg1Validator.class);
	}

	@Override
	public Validator<? super SpreadOfLeg1> typeFormatValidator(ValidatorFactory factory) {
		return factory.<SpreadOfLeg1>create(SpreadOfLeg1TypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super SpreadOfLeg1> validator() {
		return new SpreadOfLeg1Validator();
	}

	@Deprecated
	@Override
	public Validator<? super SpreadOfLeg1> typeFormatValidator() {
		return new SpreadOfLeg1TypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super SpreadOfLeg1, Set<String>> onlyExistsValidator() {
		return new SpreadOfLeg1OnlyExistsValidator();
	}
}
