package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;


@ImplementedBy(CurrencyOfThePriceTimeIntervalQuantityRule.CurrencyOfThePriceTimeIntervalQuantityRuleDefault.class)
public abstract class CurrencyOfThePriceTimeIntervalQuantityRule implements ReportFunction<ReportableDelivery, ISOCurrencyCodeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ISOCurrencyCodeEnum evaluate(ReportableDelivery input) {
		ISOCurrencyCodeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ISOCurrencyCodeEnum doEvaluate(ReportableDelivery input);

	public static class CurrencyOfThePriceTimeIntervalQuantityRuleDefault extends CurrencyOfThePriceTimeIntervalQuantityRule {
		@Override
		protected ISOCurrencyCodeEnum doEvaluate(ReportableDelivery input) {
			ISOCurrencyCodeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum output, ReportableDelivery input) {
			final MapperS<String> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> item.<String>map("getCurrencyOfThePriceTimeIntervalQuantity", reportableDelivery -> reportableDelivery.getCurrencyOfThePriceTimeIntervalQuantity()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(convertNonISOToISOCurrency.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
