package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.standards.iosco.cde.reports.CDENotionalAmountScheduleEffectiveDateRule;
import javax.inject.Inject;


@ImplementedBy(EffectiveDateOfTheNotionalAmountOfLeg1Rule.EffectiveDateOfTheNotionalAmountOfLeg1RuleDefault.class)
public abstract class EffectiveDateOfTheNotionalAmountOfLeg1Rule implements ReportFunction<QuantityReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDENotionalAmountScheduleEffectiveDateRule cDENotionalAmountScheduleEffectiveDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(QuantityReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(QuantityReportablePeriod input);

	public static class EffectiveDateOfTheNotionalAmountOfLeg1RuleDefault extends EffectiveDateOfTheNotionalAmountOfLeg1Rule {
		@Override
		protected Date doEvaluate(QuantityReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, QuantityReportablePeriod input) {
			output = cDENotionalAmountScheduleEffectiveDateRule.evaluate(input);
			
			return output;
		}
	}
}
