package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.MultiplyPrice;
import drr.standards.iosco.cde.reports.CDEPriceNotationEnumRule;
import drr.standards.iosco.cde.reports.CDEPriceRule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PriceFormatBasisRule.PriceFormatBasisRuleDefault.class)
public abstract class PriceFormatBasisRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPriceNotationEnumRule cDEPriceNotationEnumRule;
	@Inject protected CDEPriceRule cDEPriceRule;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class PriceFormatBasisRuleDefault extends PriceFormatBasisRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(cDEPriceNotationEnumRule.evaluate(item.get())), MapperS.of(PriceNotationEnum.BASIS), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of(multiplyPrice.evaluate(cDEPriceRule.evaluate(item.get()), PriceNotationEnum.BASIS));
					}
					return MapperS.<BigDecimal>ofNull();
				}).get();
			
			return output;
		}
	}
}
