package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsAllowableAction;
import drr.standards.iosco.cde.reports.CDEStrikePriceCurrencyRule;
import javax.inject.Inject;


@ImplementedBy(StrikePriceCurrencyCurrencyPairRule.StrikePriceCurrencyCurrencyPairRuleDefault.class)
public abstract class StrikePriceCurrencyCurrencyPairRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEStrikePriceCurrencyRule cDEStrikePriceCurrencyRule;
	@Inject protected IsAllowableAction isAllowableAction;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class StrikePriceCurrencyCurrencyPairRuleDefault extends StrikePriceCurrencyCurrencyPairRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = MapperS.of(cDEStrikePriceCurrencyRule.evaluate(thenArg.get())).get();
			
			return output;
		}
	}
}
