package drr.regulation.fca.ukemir.refit.trade.validation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.SpreadOfLeg1;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class SpreadOfLeg1Validator implements Validator<SpreadOfLeg1> {

	private List<ComparisonResult> getComparisonResults(SpreadOfLeg1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("spreadOfLeg1Monetary", (BigDecimal) o.getSpreadOfLeg1Monetary() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg1Percentage", (BigDecimal) o.getSpreadOfLeg1Percentage() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg1Basis", (BigDecimal) o.getSpreadOfLeg1Basis() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadCurrencyOfLeg1", (ISOCurrencyCodeEnum) o.getSpreadCurrencyOfLeg1() != null ? 1 : 0, 0, 1), 
				checkCardinality("spreadOfLeg1Notation", (PriceNotationEnum) o.getSpreadOfLeg1Notation() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("SpreadOfLeg1", ValidationResult.ValidationType.CARDINALITY, "SpreadOfLeg1", path, "", res.getError());
				}
				return success("SpreadOfLeg1", ValidationResult.ValidationType.CARDINALITY, "SpreadOfLeg1", path, "");
			})
			.collect(toList());
	}

}
