package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.fca.ukemir.refit.trade.SpreadOfLeg1;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("SpreadOfLeg1MonetaryOrPercentageOrBasis")
@ImplementedBy(SpreadOfLeg1MonetaryOrPercentageOrBasis.Default.class)
public interface SpreadOfLeg1MonetaryOrPercentageOrBasis extends Validator<SpreadOfLeg1> {
	
	String NAME = "SpreadOfLeg1MonetaryOrPercentageOrBasis";
	String DEFINITION = "optional choice spreadOfLeg1Monetary, spreadOfLeg1Percentage, spreadOfLeg1Basis";
	
	class Default implements SpreadOfLeg1MonetaryOrPercentageOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg1 spreadOfLeg1) {
			ComparisonResult result = executeDataRule(spreadOfLeg1);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadOfLeg1", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SpreadOfLeg1", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SpreadOfLeg1 spreadOfLeg1) {
			try {
				return choice(MapperS.of(spreadOfLeg1), Arrays.asList("spreadOfLeg1Monetary", "spreadOfLeg1Percentage", "spreadOfLeg1Basis"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SpreadOfLeg1MonetaryOrPercentageOrBasis {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SpreadOfLeg1 spreadOfLeg1) {
			return Collections.emptyList();
		}
	}
}
