package drr.regulation.jfsa.rewrite.margin.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.MarginActionEnum;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import drr.regulation.jfsa.rewrite.margin.JFSAMarginReport;
import drr.regulation.jfsa.rewrite.margin.PartiesToTheDerivative;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("JFSAMarginReportDTCC_JFSA_BR_0008_01")
@ImplementedBy(JFSAMarginReportDTCC_JFSA_BR_0008_01.Default.class)
public interface JFSAMarginReportDTCC_JFSA_BR_0008_01 extends Validator<JFSAMarginReport> {
	
	String NAME = "JFSAMarginReportDTCC_JFSA_BR_0008_01";
	String DEFINITION = "if collateral -> actionType = MarginActionEnum -> MARU then (if partiesToTheDerivative -> counterparty2IdentifierType = True then partiesToTheDerivative -> counterparty2 <> partiesToTheDerivative -> counterparty1)";
	
	class Default implements JFSAMarginReportDTCC_JFSA_BR_0008_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSAMarginReport jFSAMarginReport) {
			ComparisonResult result = executeDataRule(jFSAMarginReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSAMarginReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "JFSAMarginReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(JFSAMarginReport jFSAMarginReport) {
			try {
				if (areEqual(MapperS.of(jFSAMarginReport).<CollateralReport>map("getCollateral", _jFSAMarginReport -> _jFSAMarginReport.getCollateral()).<MarginActionEnum>map("getActionType", collateralReport -> collateralReport.getActionType()), MapperS.of(MarginActionEnum.MARU), CardinalityOperator.All).getOrDefault(false)) {
					if (areEqual(MapperS.of(jFSAMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _jFSAMarginReport -> _jFSAMarginReport.getPartiesToTheDerivative()).<Boolean>map("getCounterparty2IdentifierType", partiesToTheDerivative -> partiesToTheDerivative.getCounterparty2IdentifierType()), MapperS.of(true), CardinalityOperator.All).getOrDefault(false)) {
						return notEqual(MapperS.of(jFSAMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _jFSAMarginReport -> _jFSAMarginReport.getPartiesToTheDerivative()).<String>map("getCounterparty2", partiesToTheDerivative -> partiesToTheDerivative.getCounterparty2()), MapperS.of(jFSAMarginReport).<PartiesToTheDerivative>map("getPartiesToTheDerivative", _jFSAMarginReport -> _jFSAMarginReport.getPartiesToTheDerivative()).<String>map("getCounterparty1", partiesToTheDerivative -> partiesToTheDerivative.getCounterparty1()), CardinalityOperator.Any);
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements JFSAMarginReportDTCC_JFSA_BR_0008_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSAMarginReport jFSAMarginReport) {
			return Collections.emptyList();
		}
	}
}
