package drr.regulation.jfsa.rewrite.trade;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.jfsa.rewrite.trade.meta.PackageTransactionPriceMeta;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 5.58.0
 */
@RosettaDataType(value="PackageTransactionPrice", builder=PackageTransactionPrice.PackageTransactionPriceBuilderImpl.class, version="5.58.0")
@RuneDataType(value="PackageTransactionPrice", model="drr", builder=PackageTransactionPrice.PackageTransactionPriceBuilderImpl.class, version="5.58.0")
public interface PackageTransactionPrice extends RosettaModelObject {

	PackageTransactionPriceMeta metaData = new PackageTransactionPriceMeta();

	/*********************** Getter Methods  ***********************/
	BigDecimal getPackageTransactionPriceMonetary();
	BigDecimal getPackageTransactionPriceDecimal();
	BigDecimal getPackageTransactionPriceBasis();
	PriceNotationEnum getPackageTransactionPriceNotation();

	/*********************** Build Methods  ***********************/
	PackageTransactionPrice build();
	
	PackageTransactionPrice.PackageTransactionPriceBuilder toBuilder();
	
	static PackageTransactionPrice.PackageTransactionPriceBuilder builder() {
		return new PackageTransactionPrice.PackageTransactionPriceBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends PackageTransactionPrice> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends PackageTransactionPrice> getType() {
		return PackageTransactionPrice.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("packageTransactionPriceMonetary"), BigDecimal.class, getPackageTransactionPriceMonetary(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceDecimal"), BigDecimal.class, getPackageTransactionPriceDecimal(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceBasis"), BigDecimal.class, getPackageTransactionPriceBasis(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface PackageTransactionPriceBuilder extends PackageTransactionPrice, RosettaModelObjectBuilder {
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceMonetary(BigDecimal packageTransactionPriceMonetary);
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceDecimal(BigDecimal packageTransactionPriceDecimal);
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceBasis(BigDecimal packageTransactionPriceBasis);
		PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("packageTransactionPriceMonetary"), BigDecimal.class, getPackageTransactionPriceMonetary(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceDecimal"), BigDecimal.class, getPackageTransactionPriceDecimal(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceBasis"), BigDecimal.class, getPackageTransactionPriceBasis(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		}
		

		PackageTransactionPrice.PackageTransactionPriceBuilder prune();
	}

	/*********************** Immutable Implementation of PackageTransactionPrice  ***********************/
	class PackageTransactionPriceImpl implements PackageTransactionPrice {
		private final BigDecimal packageTransactionPriceMonetary;
		private final BigDecimal packageTransactionPriceDecimal;
		private final BigDecimal packageTransactionPriceBasis;
		private final PriceNotationEnum packageTransactionPriceNotation;
		
		protected PackageTransactionPriceImpl(PackageTransactionPrice.PackageTransactionPriceBuilder builder) {
			this.packageTransactionPriceMonetary = builder.getPackageTransactionPriceMonetary();
			this.packageTransactionPriceDecimal = builder.getPackageTransactionPriceDecimal();
			this.packageTransactionPriceBasis = builder.getPackageTransactionPriceBasis();
			this.packageTransactionPriceNotation = builder.getPackageTransactionPriceNotation();
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceMonetary")
		@RuneAttribute("packageTransactionPriceMonetary")
		public BigDecimal getPackageTransactionPriceMonetary() {
			return packageTransactionPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceDecimal")
		@RuneAttribute("packageTransactionPriceDecimal")
		public BigDecimal getPackageTransactionPriceDecimal() {
			return packageTransactionPriceDecimal;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceBasis")
		@RuneAttribute("packageTransactionPriceBasis")
		public BigDecimal getPackageTransactionPriceBasis() {
			return packageTransactionPriceBasis;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public PriceNotationEnum getPackageTransactionPriceNotation() {
			return packageTransactionPriceNotation;
		}
		
		@Override
		public PackageTransactionPrice build() {
			return this;
		}
		
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder toBuilder() {
			PackageTransactionPrice.PackageTransactionPriceBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(PackageTransactionPrice.PackageTransactionPriceBuilder builder) {
			ofNullable(getPackageTransactionPriceMonetary()).ifPresent(builder::setPackageTransactionPriceMonetary);
			ofNullable(getPackageTransactionPriceDecimal()).ifPresent(builder::setPackageTransactionPriceDecimal);
			ofNullable(getPackageTransactionPriceBasis()).ifPresent(builder::setPackageTransactionPriceBasis);
			ofNullable(getPackageTransactionPriceNotation()).ifPresent(builder::setPackageTransactionPriceNotation);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PackageTransactionPrice _that = getType().cast(o);
		
			if (!Objects.equals(packageTransactionPriceMonetary, _that.getPackageTransactionPriceMonetary())) return false;
			if (!Objects.equals(packageTransactionPriceDecimal, _that.getPackageTransactionPriceDecimal())) return false;
			if (!Objects.equals(packageTransactionPriceBasis, _that.getPackageTransactionPriceBasis())) return false;
			if (!Objects.equals(packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (packageTransactionPriceMonetary != null ? packageTransactionPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceDecimal != null ? packageTransactionPriceDecimal.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceBasis != null ? packageTransactionPriceBasis.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceNotation != null ? packageTransactionPriceNotation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PackageTransactionPrice {" +
				"packageTransactionPriceMonetary=" + this.packageTransactionPriceMonetary + ", " +
				"packageTransactionPriceDecimal=" + this.packageTransactionPriceDecimal + ", " +
				"packageTransactionPriceBasis=" + this.packageTransactionPriceBasis + ", " +
				"packageTransactionPriceNotation=" + this.packageTransactionPriceNotation +
			'}';
		}
	}

	/*********************** Builder Implementation of PackageTransactionPrice  ***********************/
	class PackageTransactionPriceBuilderImpl implements PackageTransactionPrice.PackageTransactionPriceBuilder {
	
		protected BigDecimal packageTransactionPriceMonetary;
		protected BigDecimal packageTransactionPriceDecimal;
		protected BigDecimal packageTransactionPriceBasis;
		protected PriceNotationEnum packageTransactionPriceNotation;
		
		@Override
		@RosettaAttribute("packageTransactionPriceMonetary")
		@RuneAttribute("packageTransactionPriceMonetary")
		public BigDecimal getPackageTransactionPriceMonetary() {
			return packageTransactionPriceMonetary;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceDecimal")
		@RuneAttribute("packageTransactionPriceDecimal")
		public BigDecimal getPackageTransactionPriceDecimal() {
			return packageTransactionPriceDecimal;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceBasis")
		@RuneAttribute("packageTransactionPriceBasis")
		public BigDecimal getPackageTransactionPriceBasis() {
			return packageTransactionPriceBasis;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public PriceNotationEnum getPackageTransactionPriceNotation() {
			return packageTransactionPriceNotation;
		}
		
		@RosettaAttribute("packageTransactionPriceMonetary")
		@RuneAttribute("packageTransactionPriceMonetary")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceMonetary(BigDecimal _packageTransactionPriceMonetary) {
			this.packageTransactionPriceMonetary = _packageTransactionPriceMonetary == null ? null : _packageTransactionPriceMonetary;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceDecimal")
		@RuneAttribute("packageTransactionPriceDecimal")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceDecimal(BigDecimal _packageTransactionPriceDecimal) {
			this.packageTransactionPriceDecimal = _packageTransactionPriceDecimal == null ? null : _packageTransactionPriceDecimal;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceBasis")
		@RuneAttribute("packageTransactionPriceBasis")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceBasis(BigDecimal _packageTransactionPriceBasis) {
			this.packageTransactionPriceBasis = _packageTransactionPriceBasis == null ? null : _packageTransactionPriceBasis;
			return this;
		}
		
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@Override
		public PackageTransactionPrice build() {
			return new PackageTransactionPrice.PackageTransactionPriceImpl(this);
		}
		
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getPackageTransactionPriceMonetary()!=null) return true;
			if (getPackageTransactionPriceDecimal()!=null) return true;
			if (getPackageTransactionPriceBasis()!=null) return true;
			if (getPackageTransactionPriceNotation()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public PackageTransactionPrice.PackageTransactionPriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			PackageTransactionPrice.PackageTransactionPriceBuilder o = (PackageTransactionPrice.PackageTransactionPriceBuilder) other;
			
			
			merger.mergeBasic(getPackageTransactionPriceMonetary(), o.getPackageTransactionPriceMonetary(), this::setPackageTransactionPriceMonetary);
			merger.mergeBasic(getPackageTransactionPriceDecimal(), o.getPackageTransactionPriceDecimal(), this::setPackageTransactionPriceDecimal);
			merger.mergeBasic(getPackageTransactionPriceBasis(), o.getPackageTransactionPriceBasis(), this::setPackageTransactionPriceBasis);
			merger.mergeBasic(getPackageTransactionPriceNotation(), o.getPackageTransactionPriceNotation(), this::setPackageTransactionPriceNotation);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			PackageTransactionPrice _that = getType().cast(o);
		
			if (!Objects.equals(packageTransactionPriceMonetary, _that.getPackageTransactionPriceMonetary())) return false;
			if (!Objects.equals(packageTransactionPriceDecimal, _that.getPackageTransactionPriceDecimal())) return false;
			if (!Objects.equals(packageTransactionPriceBasis, _that.getPackageTransactionPriceBasis())) return false;
			if (!Objects.equals(packageTransactionPriceNotation, _that.getPackageTransactionPriceNotation())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (packageTransactionPriceMonetary != null ? packageTransactionPriceMonetary.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceDecimal != null ? packageTransactionPriceDecimal.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceBasis != null ? packageTransactionPriceBasis.hashCode() : 0);
			_result = 31 * _result + (packageTransactionPriceNotation != null ? packageTransactionPriceNotation.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "PackageTransactionPriceBuilder {" +
				"packageTransactionPriceMonetary=" + this.packageTransactionPriceMonetary + ", " +
				"packageTransactionPriceDecimal=" + this.packageTransactionPriceDecimal + ", " +
				"packageTransactionPriceBasis=" + this.packageTransactionPriceBasis + ", " +
				"packageTransactionPriceNotation=" + this.packageTransactionPriceNotation +
			'}';
		}
	}
}
