package drr.regulation.jfsa.rewrite.trade.labels;

import com.regnosys.rosetta.lib.labelprovider.GraphBasedLabelProvider;
import com.regnosys.rosetta.lib.labelprovider.LabelNode;
import java.util.Arrays;


public class JFSATradeLabelProvider extends GraphBasedLabelProvider {
	public JFSATradeLabelProvider() {
		super(new LabelNode());
		
		startNode.addLabel(Arrays.asList("effectiveDate"), "1 Effective Date");
		startNode.addLabel(Arrays.asList("expirationDate"), "2 Expiration date");
		startNode.addLabel(Arrays.asList("earlyTerminationDate"), "3 Early termination date");
		startNode.addLabel(Arrays.asList("reportingTimestamp"), "4 Reporting timestamp");
		startNode.addLabel(Arrays.asList("executionTimestamp"), "5 Execution timestamp");
		startNode.addLabel(Arrays.asList("entityResponsibleForReporting"), "6 Entity responsible for reporting");
		startNode.addLabel(Arrays.asList("counterparty1"), "7 Counterparty 1");
		startNode.addLabel(Arrays.asList("counterparty2"), "8 Counterparty 2");
		startNode.addLabel(Arrays.asList("counterparty2IdentifierType"), "9 Counterparty 2 identifier type");
		startNode.addLabel(Arrays.asList("direction1"), "10 Direction 1");
		startNode.addLabel(Arrays.asList("direction2Leg1"), "11 Direction 2-Leg 1");
		startNode.addLabel(Arrays.asList("direction2Leg2"), "11 Direction 2-Leg 2");
		startNode.addLabel(Arrays.asList("submitterIdentifier"), "12 Submitter identifier");
		startNode.addLabel(Arrays.asList("newSDRIdentifier"), "13 New SDR identifier");
		startNode.addLabel(Arrays.asList("originalSwapSDRIdentifier"), "14 Original swap SDR identifier");
		startNode.addLabel(Arrays.asList("cleared"), "15 Cleared");
		startNode.addLabel(Arrays.asList("centralCounterparty"), "16 Central counterparty");
		startNode.addLabel(Arrays.asList("clearingMember"), "17 Clearing member");
		startNode.addLabel(Arrays.asList("platformIdentifier"), "18 Platform Identifier");
		startNode.addLabel(Arrays.asList("confirmed"), "19 Confirmed");
		startNode.addLabel(Arrays.asList("finalContractualSettlementDate"), "20 Final contractual settlement date");
		startNode.addLabel(Arrays.asList("confirmationTimestamp"), "[Internal] Confirmation Timestamp (DTCC)");
		startNode.addLabel(Arrays.asList("settlementCurrencyLeg1"), "21 Settlement Currency-Leg 1");
		startNode.addLabel(Arrays.asList("settlementCurrencyLeg2"), "21 Settlement Currency-Leg 2");
		startNode.addLabel(Arrays.asList("clearingAccountOrigin"), "22 Clearing account origin");
		startNode.addLabel(Arrays.asList("originalSwapUTI"), "23 Original Swap UTI");
		startNode.addLabel(Arrays.asList("originalSwapUTIProprietary"), "23 Original Swap UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("clearingReceiptTimestamp"), "24 Clearing receipt timestamp");
		startNode.addLabel(Arrays.asList("uti"), "25 Unique transaction identifier (UTI)");
		startNode.addLabel(Arrays.asList("utiProprietary"), "25 Unique transaction identifier (UTI Proprietary)");
		startNode.addLabel(Arrays.asList("priorUti"), "26 Prior UTI");
		startNode.addLabel(Arrays.asList("priorUtiProprietary"), "26 Prior UTI (Proprietary)");
		startNode.addLabel(Arrays.asList("fixedRateDayCountConventionLeg1"), "27 Fixed rate day count convention-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateDayCountConventionOfLeg1"), "27 Floating rate day count convention of leg 1");
		startNode.addLabel(Arrays.asList("fixedRateDayCountConventionLeg2"), "27 Fixed rate day count convention leg 2");
		startNode.addLabel(Arrays.asList("floatingRateDayCountConventionOfLeg2"), "27 Floating rate day count convention of leg 2");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodLeg1"), "28 Fixed rate payment frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodLeg2"), "28 Fixed rate payment frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodLeg1"), "28 Floating rate payment frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodLeg2"), "28 Floating rate payment frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodMultiplierLeg1"), "29 Fixed rate payment frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("fixedRatePaymentFrequencyPeriodMultiplierLeg2"), "29 Fixed rate payment frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodMultiplierLeg1"), "29 Floating rate payment frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRatePaymentFrequencyPeriodMultiplierLeg2"), "29 Floating rate payment frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("fixingDateLeg1"), "30 Fixing date-Leg 1");
		startNode.addLabel(Arrays.asList("fixingDateLeg2"), "30 Fixing date-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodLeg1"), "31 Floating rate reset frequency period-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodOfLeg2"), "31 Floating rate reset frequency period-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodMultiplierLeg1"), "32 Floating rate reset frequency period multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateResetFrequencyPeriodMultiplierLeg2"), "32 Floating rate reset frequency period multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("valuationAmount"), "39 Valuation amount");
		startNode.addLabel(Arrays.asList("valuationCurrency"), "40 Valuation currency");
		startNode.addLabel(Arrays.asList("valuationMethod"), "42 Valuation method");
		startNode.addLabel(Arrays.asList("valuationTimestamp"), "41 Valuation Timestamp");
		startNode.addLabel(Arrays.asList("collateralPortfolioIndicator"), "44 Collateral Portfolio Indicator");
		startNode.addLabel(Arrays.asList("initialMarginCollateralPortfolioCode"), "62 Initial margin collateral portfolio code");
		startNode.addLabel(Arrays.asList("variationMarginCollateralPortfolioCode"), "63 Variation margin collateral portfolio code");
		startNode.addLabel(Arrays.asList("priceNotation"), "66 Price notation");
		startNode.addLabel(Arrays.asList("priceUnitOfMeasure"), "67 Price unit of measure");
		startNode.addLabel(Arrays.asList("fixedRateLeg1"), "71 Fixed rate-Leg 1");
		startNode.addLabel(Arrays.asList("fixedRateLeg2"), "71 Fixed rate-Leg 2");
		startNode.addLabel(Arrays.asList("spreadNotationOfLeg1"), "74 Spread notation-Leg 1");
		startNode.addLabel(Arrays.asList("spreadNotationOfLeg2"), "74 Spread notation-Leg 2");
		startNode.addLabel(Arrays.asList("strikePriceNotation"), "77 Strike price notation");
		startNode.addLabel(Arrays.asList("optionPremiumAmount"), "81 Option premium amount");
		startNode.addLabel(Arrays.asList("optionPremiumCurrency"), "82 Option premium currency");
		startNode.addLabel(Arrays.asList("optionPremiumPaymentDate"), "83 Option premium payment date");
		startNode.addLabel(Arrays.asList("firstExerciseDate"), "84 First exercise date");
		startNode.addLabel(Arrays.asList("exchangeRate"), "85 Exchange rate");
		startNode.addLabel(Arrays.asList("exchangeRateBasis"), "86 Exchange rate basis");
		startNode.addLabel(Arrays.asList("notionalLeg1"), "87 Notional Amount 1");
		startNode.addLabel(Arrays.asList("notionalLeg2"), "87 Notional Amount 2");
		startNode.addLabel(Arrays.asList("callAmount"), "88 Call amount");
		startNode.addLabel(Arrays.asList("putAmount"), "89 Put Amount");
		startNode.addLabel(Arrays.asList("notionalCurrencyOfLeg1"), "90 Notional currency-Leg 1");
		startNode.addLabel(Arrays.asList("notionalCurrencyOfLeg2"), "90 Notional currency-Leg 2");
		startNode.addLabel(Arrays.asList("callCurrency"), "91 Call currency");
		startNode.addLabel(Arrays.asList("putCurrency"), "92 Put currency");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg1"), "93 Quantity unit of measure-Leg 1");
		startNode.addLabel(Arrays.asList("quantityUnitOfMeasureLeg2"), "93 Quantity unit of measure-Leg 2");
		startNode.addLabel(Arrays.asList("totalNotionalQuantityLeg1"), "97 Total notional quantity-Leg 1");
		startNode.addLabel(Arrays.asList("totalNotionalQuantityLeg2"), "97 Total notional quantity-Leg 2");
		startNode.addLabel(Arrays.asList("actionType"), "101 Action type");
		startNode.addLabel(Arrays.asList("eventType"), "102 Event type");
		startNode.addLabel(Arrays.asList("eventTimestamp"), "104 Event timestamp");
		startNode.addLabel(Arrays.asList("eventIdentifier"), "103 Event identifier");
		startNode.addLabel(Arrays.asList("indexFactor"), "105 Index factor");
		startNode.addLabel(Arrays.asList("embeddedOptionType"), "106 Embedded option type");
		startNode.addLabel(Arrays.asList("upi"), "107 UPI");
		startNode.addLabel(Arrays.asList("deliveryType"), "108 Delivery Type");
		startNode.addLabel(Arrays.asList("assetClass"), "109 Asset Class");
		startNode.addLabel(Arrays.asList("underlyingIdentificationType"), "110 Underlying identification type");
		startNode.addLabel(Arrays.asList("underlyingIdentification"), "111 Underlying identification");
		startNode.addLabel(Arrays.asList("underlyingIndexIndicator"), "112 Indicator of the underlying index");
		startNode.addLabel(Arrays.asList("nameOfTheUnderlyingIndex"), "113 Name of the underlying index");
		startNode.addLabel(Arrays.asList("referenceEntity"), "114 Reference entity");
		startNode.addLabel(Arrays.asList("indicatorOfTheFloatingRateOfLeg1"), "115 Indicator of the floating rate-Leg 1");
		startNode.addLabel(Arrays.asList("indicatorOfTheFloatingRateOfLeg2"), "115 Indicator of the floating rate-Leg 2");
		startNode.addLabel(Arrays.asList("nameOfTheFloatingRateOfLeg1"), "116 Name of the Floating Rate of Leg 1");
		startNode.addLabel(Arrays.asList("nameOfTheFloatingRateOfLeg2"), "116 Name of the Floating Rate of Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateReferencePeriodOfLeg1TimePeriod"), "117 Floating rate reference period - time period-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateReferencePeriodOfLeg2TimePeriod"), "117 Floating rate reference period - time period-Leg 2");
		startNode.addLabel(Arrays.asList("floatingRateReferencePeriodOfLeg1Multiplier"), "118 Floating rate reference period - multiplier-Leg 1");
		startNode.addLabel(Arrays.asList("floatingRateReferencePeriodOfLeg2Multiplier"), "118 Floating rate reference period - multiplier-Leg 2");
		startNode.addLabel(Arrays.asList("isCrypto"), "119 Derivative based on crypto-assets");
		startNode.addLabel(Arrays.asList("maturityDateOfTheUnderlying"), "120 Maturity date of the underlying");
		startNode.addLabel(Arrays.asList("seniority"), "121 Seniority");
		startNode.addLabel(Arrays.asList("series"), "122 Series");
		startNode.addLabel(Arrays.asList("version"), "123 Version");
		startNode.addLabel(Arrays.asList("cdSIndexAttachmentPoint"), "124 CDS index attachment point");
		startNode.addLabel(Arrays.asList("cdSIndexDetachmentPoint"), "125 CDS index detachment point");
		startNode.addLabel(Arrays.asList("customBasketCode"), "126 Custom basket code");
		startNode.addLabel(Arrays.asList("contractType"), "129 Contract Type");
		startNode.addLabel(Arrays.asList("optionStyle"), "130 Option style");
		startNode.addLabel(Arrays.asList("optionType"), "131 Option type");
		startNode.addLabel(Arrays.asList("packageIdentifier"), "132 Package identifier");
		startNode.addLabel(Arrays.asList("packageTransactionPriceCurrency"), "134 Package transaction price currency");
		startNode.addLabel(Arrays.asList("packageTransactionPriceNotation"), "135 Package Transaction Price Notation");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadCurrency"), "137 Package transaction spread currency");
		startNode.addLabel(Arrays.asList("packageTransactionSpreadNotation"), "138 Package transaction spread notation");
		startNode.addLabel(Arrays.asList("delta"), "43 Delta");
		startNode.addLabel(Arrays.asList("technicalRecordId"), "[Internal] Technical Record Id (ISO)");
		
		LabelNode priceAndNotationNode = new LabelNode();
		priceAndNotationNode.addLabel(Arrays.asList("priceMonetary"), "64 Price (Monetary)");
		priceAndNotationNode.addLabel(Arrays.asList("priceDecimal"), "64 Price (Decimal)");
		priceAndNotationNode.addLabel(Arrays.asList("priceCurrency"), "65 Price currency");
		
		LabelNode spreadOfLeg1Node = new LabelNode();
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Monetary"), "72 Spread-Leg 1 (Monetary)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Decimal"), "72 Spread-Leg 1 (Decimal)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadOfLeg1Basis"), "72 Spread-Leg 1 (Basis)");
		spreadOfLeg1Node.addLabel(Arrays.asList("spreadCurrencyOfLeg1"), "73 Spread currency-Leg 1");
		
		LabelNode spreadOfLeg2Node = new LabelNode();
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Monetary"), "72 Spread-Leg 2 (Monetary)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Decimal"), "72 Spread-Leg 2 (Decimal)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadOfLeg2Basis"), "72 Spread-Leg 2 (Basis)");
		spreadOfLeg2Node.addLabel(Arrays.asList("spreadCurrencyOfLeg2"), "73 Spread currency-Leg 2");
		
		LabelNode strikePriceAndNotationNode = new LabelNode();
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceMonetary"), "75 Strike Price (Monetary)");
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceDecimal"), "75 Strike Price (Decimal)");
		strikePriceAndNotationNode.addLabel(Arrays.asList("strikePriceCurrency"), "76 Strike price currency");
		
		LabelNode packageTransactionPriceNode = new LabelNode();
		packageTransactionPriceNode.addLabel(Arrays.asList("packageTransactionPriceMonetary"), "133 Package Transaction Price (Monetary)");
		packageTransactionPriceNode.addLabel(Arrays.asList("packageTransactionPriceDecimal"), "133 Package Transaction Price (Decimal)");
		packageTransactionPriceNode.addLabel(Arrays.asList("packageTransactionPriceBasis"), "133 Package Transaction Price (Basis)");
		
		LabelNode packageTransactionSpreadNode = new LabelNode();
		packageTransactionSpreadNode.addLabel(Arrays.asList("packageTransactionSpreadMonetary"), "136 Package transaction spread (Monetary)");
		packageTransactionSpreadNode.addLabel(Arrays.asList("packageTransactionSpreadDecimal"), "136 Package transaction spread (Decimal)");
		packageTransactionSpreadNode.addLabel(Arrays.asList("packageTransactionSpreadBasis"), "136 Package transaction spread (Basis)");
		
		LabelNode barrierAndNotationNode = new LabelNode();
		barrierAndNotationNode.addLabel(Arrays.asList("singleBarrierPriceMonetary"), "[Not in regulation] Single barrier price (monetary)");
		barrierAndNotationNode.addLabel(Arrays.asList("singleBarrierPriceDecimal"), "[Not in regulation] Single barrier price (decimal)");
		barrierAndNotationNode.addLabel(Arrays.asList("lowerBarrierPriceMonetary"), "[Not in regulation] Lower barrier price (monetary)");
		barrierAndNotationNode.addLabel(Arrays.asList("lowerBarrierPriceDecimal"), "[Not in regulation] Lower barrier price (decimal)");
		barrierAndNotationNode.addLabel(Arrays.asList("upperBarrierPriceMonetary"), "[Not in regulation] Upper barrier price (monetary)");
		barrierAndNotationNode.addLabel(Arrays.asList("upperBarrierPriceDecimal"), "[Not in regulation] Upper barrier price (decimal)");
		barrierAndNotationNode.addLabel(Arrays.asList("singleBarrierPriceNotation"), "[Not in regulation] Single barrier price notation");
		barrierAndNotationNode.addLabel(Arrays.asList("lowerBarrierPriceNotation"), "[Not in regulation] Lower barrier price notation");
		barrierAndNotationNode.addLabel(Arrays.asList("upperBarrierPriceNotation"), "[Not in regulation] Upper barrier price notation");
		barrierAndNotationNode.addLabel(Arrays.asList("singleBarrierPriceCurrency"), "[Not in regulation] Single barrier price currency");
		barrierAndNotationNode.addLabel(Arrays.asList("lowerBarrierPriceCurrency"), "[Not in regulation] Lower barrier price currency");
		barrierAndNotationNode.addLabel(Arrays.asList("upperBarrierPriceCurrency"), "[Not in regulation] Upper barrier price currency");
		
		LabelNode jFSANonReportableNode = new LabelNode();
		jFSANonReportableNode.addLabel(Arrays.asList("enrichment"), "Enrichment Data");
		
		startNode.addOutgoingEdge("price", priceAndNotationNode);
		startNode.addOutgoingEdge("spreadOfLeg1", spreadOfLeg1Node);
		startNode.addOutgoingEdge("spreadOfLeg2", spreadOfLeg2Node);
		startNode.addOutgoingEdge("strikePrice", strikePriceAndNotationNode);
		startNode.addOutgoingEdge("packageTransactionPrice", packageTransactionPriceNode);
		startNode.addOutgoingEdge("packageTransactionSpread", packageTransactionSpreadNode);
		startNode.addOutgoingEdge("barrier", barrierAndNotationNode);
		startNode.addOutgoingEdge("nonReportable", jFSANonReportableNode);
	}
}
