package drr.regulation.jfsa.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.IsActionTypeCORR;
import drr.regulation.common.functions.IsActionTypeEROR;
import drr.regulation.common.functions.IsActionTypeMODI;
import drr.regulation.common.functions.IsActionTypeNEWT;
import drr.regulation.common.functions.IsActionTypePRTO;
import drr.regulation.common.functions.IsActionTypeREVI;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.IsActionTypeVALU;
import javax.inject.Inject;


@ImplementedBy(ActionTypeRule.ActionTypeRuleDefault.class)
public abstract class ActionTypeRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsActionTypeCORR isActionTypeCORR;
	@Inject protected IsActionTypeEROR isActionTypeEROR;
	@Inject protected IsActionTypeMODI isActionTypeMODI;
	@Inject protected IsActionTypeNEWT isActionTypeNEWT;
	@Inject protected IsActionTypePRTO isActionTypePRTO;
	@Inject protected IsActionTypeREVI isActionTypeREVI;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected IsActionTypeVALU isActionTypeVALU;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class ActionTypeRuleDefault extends ActionTypeRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			output = MapperS.of(input)
				.mapSingleToItem(item -> {
					final Boolean boolean0 = isActionTypeCORR.evaluate(item.get());
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString);
					}
					final Boolean boolean1 = isActionTypeEROR.evaluate(item.get());
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(ActionTypeEnum.EROR).map("to-string", ActionTypeEnum::toDisplayString);
					}
					final Boolean boolean2 = isActionTypeREVI.evaluate(item.get());
					if ((boolean2 == null ? false : boolean2)) {
						return MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString);
					}
					final Boolean boolean3 = isActionTypePRTO.evaluate(item.get());
					if ((boolean3 == null ? false : boolean3)) {
						return MapperS.of(ActionTypeEnum.PRTO).map("to-string", ActionTypeEnum::toDisplayString);
					}
					final Boolean boolean4 = isActionTypeVALU.evaluate(item.get());
					if ((boolean4 == null ? false : boolean4)) {
						return MapperS.of(ActionTypeEnum.VALU).map("to-string", ActionTypeEnum::toDisplayString);
					}
					final Boolean boolean5 = isActionTypeTERM.evaluate(item.get());
					if ((boolean5 == null ? false : boolean5)) {
						return MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString);
					}
					final Boolean boolean6 = isActionTypeMODI.evaluate(item.get());
					if ((boolean6 == null ? false : boolean6)) {
						return MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString);
					}
					final Boolean boolean7 = isActionTypeNEWT.evaluate(item.get());
					if ((boolean7 == null ? false : boolean7)) {
						return MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString);
					}
					return MapperS.of("ToDo");
				}).get();
			
			return output;
		}
	}
}
