package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.observable.event.Trigger;
import cdm.observable.event.TriggerEvent;
import cdm.product.template.Knock;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.IsOption;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(LowerBarrierPriceNotationRule.LowerBarrierPriceNotationRuleDefault.class)
public abstract class LowerBarrierPriceNotationRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected IsOption isOption;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class LowerBarrierPriceNotationRuleDefault extends LowerBarrierPriceNotationRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					final Boolean _boolean = isOption.evaluate(productForEvent.evaluate(item.get()));
					if ((_boolean == null ? false : _boolean)) {
						if (exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn())).andNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(false)) {
							if (exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel())).orNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()))).getOrDefault(false)) {
								return MapperS.of(PriceNotationEnum.MONETARY);
							}
							if (exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevelPercentage", trigger -> trigger.getLevelPercentage())).orNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()).<TriggerEvent>mapC("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevelPercentage", trigger -> trigger.getLevelPercentage()))).getOrDefault(false)) {
								return MapperS.of(PriceNotationEnum.DECIMAL);
							}
							return MapperS.<PriceNotationEnum>ofNull();
						}
						return MapperS.<PriceNotationEnum>ofNull();
					}
					return MapperS.<PriceNotationEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
