package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.QuantityReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetReportableQuantityPeriodLeg1;
import drr.regulation.common.functions.IsAllowableAction;
import drr.regulation.common.functions.TradeForEvent;
import drr.regulation.jfsa.rewrite.trade.NotionalQuantityScheduleLeg1Report;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(NotionalQuantityScheduleLeg1Rule.NotionalQuantityScheduleLeg1RuleDefault.class)
public abstract class NotionalQuantityScheduleLeg1Rule implements ReportFunction<TransactionReportInstruction, List<? extends NotionalQuantityScheduleLeg1Report>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetReportableQuantityPeriodLeg1 getReportableQuantityPeriodLeg1;
	@Inject protected IsAllowableAction isAllowableAction;
	@Inject protected NotionalQuantityScheduleLeg1EffectiveDateRule notionalQuantityScheduleLeg1EffectiveDateRule;
	@Inject protected NotionalQuantityScheduleLeg1EndDateRule notionalQuantityScheduleLeg1EndDateRule;
	@Inject protected NotionalQuantityScheduleLeg1ValueRule notionalQuantityScheduleLeg1ValueRule;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends NotionalQuantityScheduleLeg1Report> evaluate(TransactionReportInstruction input) {
		List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends NotionalQuantityScheduleLeg1Report> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(NotionalQuantityScheduleLeg1Report::build).collect(Collectors.toList());
			objectValidator.validate(NotionalQuantityScheduleLeg1Report.class, output);
		}
		
		return output;
	}

	protected abstract List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class NotionalQuantityScheduleLeg1RuleDefault extends NotionalQuantityScheduleLeg1Rule {
		@Override
		protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> assignOutput(List<NotionalQuantityScheduleLeg1Report.NotionalQuantityScheduleLeg1ReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableAction.evaluate(item.get()));
			final MapperS<Trade> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperC<QuantityReportablePeriod> thenArg2 = thenArg1
				.mapSingleToList(item -> MapperC.<QuantityReportablePeriod>of(getReportableQuantityPeriodLeg1.evaluate(item.get())));
			final MapperC<NotionalQuantityScheduleLeg1Report> thenArg3 = thenArg2
				.mapItem(item -> MapperS.of(NotionalQuantityScheduleLeg1Report.builder()
					.setEffectiveDate(notionalQuantityScheduleLeg1EffectiveDateRule.evaluate(item.get()))
					.setEndDate(notionalQuantityScheduleLeg1EndDateRule.evaluate(item.get()))
					.setValue(notionalQuantityScheduleLeg1ValueRule.evaluate(item.get()))
					.build()));
			output = toBuilder(thenArg3
				.sort(item -> item.<Date>map("getEffectiveDate", notionalQuantityScheduleLeg1Report -> notionalQuantityScheduleLeg1Report.getEffectiveDate())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
