package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.MultiplyPrice;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iosco.cde.reports.CDESpreadLeg1Rule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SpreadOfLeg1DecimalRule.SpreadOfLeg1DecimalRuleDefault.class)
public abstract class SpreadOfLeg1DecimalRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg1Rule cDESpreadLeg1Rule;
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SpreadOfLeg1DecimalRuleDefault extends SpreadOfLeg1DecimalRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperS<ReferenceWithMetaPriceSchedule> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final PriceSchedule priceSchedule = cDESpreadLeg1Rule.evaluate(item.get());
					return priceSchedule == null ? MapperS.<ReferenceWithMetaPriceSchedule>ofNull() : MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build());
				});
			final MapperS<BigDecimal> thenArg2 = thenArg1
				.mapSingleToItem(item -> {
					final ReferenceWithMetaPriceSchedule referenceWithMetaPriceSchedule0 = item.get();
					if (areEqual(MapperC.<PriceNotationEnum>of(MapperS.of(PriceNotationEnum.PERCENTAGE), MapperS.of(PriceNotationEnum.DECIMAL)), MapperS.of(getPriceNotation.evaluate((referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()))), CardinalityOperator.Any).getOrDefault(false)) {
						return MapperS.of(multiplyPrice.evaluate(item.<PriceSchedule>map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).<BigDecimal>map("getValue", priceSchedule -> priceSchedule.getValue()).get(), PriceNotationEnum.DECIMAL));
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg2.get())).get();
			
			return output;
		}
	}
}
