package drr.regulation.jfsa.rewrite.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToBaseOneRate;
import drr.regulation.common.functions.GetPriceNotation;
import drr.regulation.common.functions.MultiplyPrice;
import drr.regulation.jfsa.rewrite.trade.functions.IsAllowableActionForJFSA;
import drr.standards.iosco.cde.reports.CDESpreadLeg2Rule;
import drr.standards.iso.PriceNotationEnum;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SpreadOfLeg2DecimalRule.SpreadOfLeg2DecimalRuleDefault.class)
public abstract class SpreadOfLeg2DecimalRule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDESpreadLeg2Rule cDESpreadLeg2Rule;
	@Inject protected FormatToBaseOneRate formatToBaseOneRate;
	@Inject protected GetPriceNotation getPriceNotation;
	@Inject protected IsAllowableActionForJFSA isAllowableActionForJFSA;
	@Inject protected MultiplyPrice multiplyPrice;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class SpreadOfLeg2DecimalRuleDefault extends SpreadOfLeg2DecimalRule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForJFSA.evaluate(item.get()));
			final MapperS<BigDecimal> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final PriceSchedule priceSchedule = cDESpreadLeg2Rule.evaluate(item.get());
					if ((priceSchedule == null ? exists(MapperS.<ReferenceWithMetaPriceSchedule>ofNull()).getOrDefault(false) : exists(MapperS.of(ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build())).getOrDefault(false))) {
						if (areEqual(MapperC.<PriceNotationEnum>of(MapperS.of(PriceNotationEnum.PERCENTAGE), MapperS.of(PriceNotationEnum.DECIMAL)), MapperS.of(getPriceNotation.evaluate(cDESpreadLeg2Rule.evaluate(item.get()))), CardinalityOperator.Any).getOrDefault(false)) {
							return MapperS.of(multiplyPrice.evaluate(MapperS.of(cDESpreadLeg2Rule.evaluate(item.get())).<BigDecimal>map("getValue", _priceSchedule -> _priceSchedule.getValue()).get(), PriceNotationEnum.DECIMAL));
						}
						return MapperS.<BigDecimal>ofNull();
					}
					return MapperS.<BigDecimal>ofNull();
				});
			output = MapperS.of(formatToBaseOneRate.evaluate(thenArg1.get())).get();
			
			return output;
		}
	}
}
