package drr.regulation.mas.rewrite.trade.functions;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import cdm.base.staticdata.party.PartyReferencePayerReceiver;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import cdm.event.common.Transfer;
import cdm.event.common.TransferState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ExtractOtherPaymentReceiver;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ExtractOtherPaymentReceiverMas.ExtractOtherPaymentReceiverMasDefault.class)
public abstract class ExtractOtherPaymentReceiverMas implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractOtherPaymentReceiver extractOtherPaymentReceiver;

	/**
	* @param transferState 
	* @param transactionReportInstruction 
	* @return partyPersonLei 
	*/
	public String evaluate(TransferState transferState, TransactionReportInstruction transactionReportInstruction) {
		String partyPersonLei = doEvaluate(transferState, transactionReportInstruction);
		
		return partyPersonLei;
	}

	protected abstract String doEvaluate(TransferState transferState, TransactionReportInstruction transactionReportInstruction);

	public static class ExtractOtherPaymentReceiverMasDefault extends ExtractOtherPaymentReceiverMas {
		@Override
		protected String doEvaluate(TransferState transferState, TransactionReportInstruction transactionReportInstruction) {
			String partyPersonLei = null;
			return assignOutput(partyPersonLei, transferState, transactionReportInstruction);
		}
		
		protected String assignOutput(String partyPersonLei, TransferState transferState, TransactionReportInstruction transactionReportInstruction) {
			if (areEqual(MapperS.of(transferState).<Transfer>map("getTransfer", _transferState -> _transferState.getTransfer()).<PartyReferencePayerReceiver>map("getPayerReceiver", transfer -> transfer.getPayerReceiver()).<ReferenceWithMetaParty>map("getReceiverPartyReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getReceiverPartyReference()).<Party>map("Type coercion", referenceWithMetaParty0 -> referenceWithMetaParty0 == null ? null : referenceWithMetaParty0.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).<PartyIdentifierTypeEnum>map("getIdentifierType", partyIdentifier -> partyIdentifier.getIdentifierType()), MapperS.of(PartyIdentifierTypeEnum.LEI), CardinalityOperator.Any).getOrDefault(false)) {
				partyPersonLei = extractOtherPaymentReceiver.evaluate(transferState, transactionReportInstruction);
			} else {
				final FieldWithMetaString fieldWithMetaString = MapperS.of(transferState).<Transfer>map("getTransfer", _transferState -> _transferState.getTransfer()).<PartyReferencePayerReceiver>map("getPayerReceiver", transfer -> transfer.getPayerReceiver()).<ReferenceWithMetaParty>map("getReceiverPartyReference", partyReferencePayerReceiver -> partyReferencePayerReceiver.getReceiverPartyReference()).<Party>map("Type coercion", referenceWithMetaParty1 -> referenceWithMetaParty1 == null ? null : referenceWithMetaParty1.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).<FieldWithMetaString>map("getIdentifier", partyIdentifier -> partyIdentifier.getIdentifier())
					.first().get();
				if (fieldWithMetaString == null) {
					partyPersonLei = null;
				} else {
					partyPersonLei = fieldWithMetaString.getValue();
				}
			}
			
			return partyPersonLei;
		}
	}
}
