package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetReportablePricePeriod;
import drr.regulation.mas.rewrite.trade.PriceScheduleReport;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;


@ImplementedBy(ContractPriceScheduleRule.ContractPriceScheduleRuleDefault.class)
public abstract class ContractPriceScheduleRule implements ReportFunction<TransactionReportInstruction, List<? extends PriceScheduleReport>> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetReportablePricePeriod getReportablePricePeriod;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateDecimalRule priceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateDecimalRule;
	@Inject protected PriceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateMonetaryRule priceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateMonetaryRule;
	@Inject protected UnadjustedEffectiveDateOfThePriceRule unadjustedEffectiveDateOfThePriceRule;
	@Inject protected UnadjustedEndDateOfThePriceRule unadjustedEndDateOfThePriceRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<? extends PriceScheduleReport> evaluate(TransactionReportInstruction input) {
		List<PriceScheduleReport.PriceScheduleReportBuilder> outputBuilder = doEvaluate(input);
		
		final List<? extends PriceScheduleReport> output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.stream().map(PriceScheduleReport::build).collect(Collectors.toList());
			objectValidator.validate(PriceScheduleReport.class, output);
		}
		
		return output;
	}

	protected abstract List<PriceScheduleReport.PriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction input);

	public static class ContractPriceScheduleRuleDefault extends ContractPriceScheduleRule {
		@Override
		protected List<PriceScheduleReport.PriceScheduleReportBuilder> doEvaluate(TransactionReportInstruction input) {
			List<PriceScheduleReport.PriceScheduleReportBuilder> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<PriceScheduleReport.PriceScheduleReportBuilder> assignOutput(List<PriceScheduleReport.PriceScheduleReportBuilder> output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForMAS.evaluate(item.get()));
			final MapperC<PriceReportablePeriod> thenArg1 = thenArg0
				.mapSingleToList(item -> MapperC.<PriceReportablePeriod>of(getReportablePricePeriod.evaluate(item.get())));
			output = toBuilder(thenArg1
				.mapItem(item -> MapperS.of(PriceScheduleReport.builder()
					.setEffectiveDate(unadjustedEffectiveDateOfThePriceRule.evaluate(item.get()))
					.setEndDate(unadjustedEndDateOfThePriceRule.evaluate(item.get()))
					.setPriceMonetary(priceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateMonetaryRule.evaluate(item.get()))
					.setPriceDecimal(priceInEffectBetweenTheUnadjustedEffectiveDateAndEndDateDecimalRule.evaluate(item.get()))
					.build())).getMulti());
			
			return Optional.ofNullable(output)
				.map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList()))
				.orElse(null);
		}
	}
}
