package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PriceReportablePeriod;
import drr.standards.iosco.cde.reports.CDEPriceScheduleEndDateRule;
import javax.inject.Inject;


@ImplementedBy(UnadjustedEndDateOfThePriceRule.UnadjustedEndDateOfThePriceRuleDefault.class)
public abstract class UnadjustedEndDateOfThePriceRule implements ReportFunction<PriceReportablePeriod, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CDEPriceScheduleEndDateRule cDEPriceScheduleEndDateRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(PriceReportablePeriod input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(PriceReportablePeriod input);

	public static class UnadjustedEndDateOfThePriceRuleDefault extends UnadjustedEndDateOfThePriceRule {
		@Override
		protected Date doEvaluate(PriceReportablePeriod input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, PriceReportablePeriod input) {
			output = cDEPriceScheduleEndDateRule.evaluate(input);
			
			return output;
		}
	}
}
