package drr.regulation.mas.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Commodity;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ExtractCommodityClassification;
import drr.regulation.common.functions.GetUnderlierProductIdentifier;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.mas.rewrite.trade.functions.IsAllowableActionForMAS;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(UnderlyingIdOtherDTCCRule.UnderlyingIdOtherDTCCRuleDefault.class)
public abstract class UnderlyingIdOtherDTCCRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected ExtractCommodityClassification extractCommodityClassification;
	@Inject protected GetUnderlierProductIdentifier getUnderlierProductIdentifier;
	@Inject protected IsAllowableActionForMAS isAllowableActionForMAS;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_AssetClass_Commodity qualify_AssetClass_Commodity;
	@Inject protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class UnderlyingIdOtherDTCCRuleDefault extends UnderlyingIdOtherDTCCRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> ComparisonResult.ofNullSafe(MapperS.of(isAllowableActionForMAS.evaluate(item.get()))).andNullSafe(areEqual(MapperS.of(qualify_AssetClass_ForeignExchange.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get())))), MapperS.of(false), CardinalityOperator.All)).get());
			final MapperS<Product> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(productForEvent.evaluate(item.get())));
			output = thenArg1
				.mapSingleToItem(item -> {
					final Boolean _boolean = qualify_AssetClass_Commodity.evaluate(economicTermsForProduct.evaluate(item.get()));
					if ((_boolean == null ? false : _boolean)) {
						final MapperS<String> thenArg = MapperS.of(extractCommodityClassification.evaluate(economicTermsForProduct.evaluate(item.get()), TaxonomySourceEnum.MAS, 1));
						final MapperS<String> ifThenElseResult;
						if (areEqual(MapperC.<String>of(MapperS.of("GROS"), MapperS.of("DIRY"), MapperS.of("LSTK"), MapperS.of("FRST"), MapperS.of("SOFT"), MapperS.of("OILP"), MapperS.of("NGAS"), MapperS.of("COAL"), MapperS.of("ELEC"), MapperS.of("INRG"), MapperS.of("PRME"), MapperS.of("NPRM"), MapperS.of("WTHR"), MapperS.of("EMIS"), MapperS.of("FRGT")), thenArg, CardinalityOperator.Any).getOrDefault(false)) {
							ifThenElseResult = thenArg;
						} else if (exists(thenArg).getOrDefault(false)) {
							ifThenElseResult = MapperS.of("OTHER");
						} else {
							ifThenElseResult = MapperS.<String>ofNull();
						}
						return ifThenElseResult;
					}
					if (exists(MapperC.<ProductIdentifier>of(getUnderlierProductIdentifier.evaluate(item.get()))).andNullSafe(notEqual(MapperC.<ProductIdentifier>of(getUnderlierProductIdentifier.evaluate(item.get())).<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()), MapperS.of(ProductIdTypeEnum.ISIN), CardinalityOperator.All)).getOrDefault(false)) {
						return MapperC.<ProductIdentifier>of(getUnderlierProductIdentifier.evaluate(item.get()))
							.first().<FieldWithMetaString>map("getIdentifier", productIdentifier -> productIdentifier.getIdentifier()).<String>map("Type coercion", fieldWithMetaString -> fieldWithMetaString == null ? null : fieldWithMetaString.getValue());
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
