package drr.regulation.mas.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0084_01")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0084_01.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0084_01 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0084_01";
	String DEFINITION = "if [ ActionTypeEnum -> NEWT to-string, ActionTypeEnum -> MODI to-string, ActionTypeEnum -> CORR to-string, ActionTypeEnum -> REVI to-string ] any = actionType and assetClass = \"COMM\" then if [\"HOUL\", \"DAIL\", \"WEEK\", \"MNTH\", \"QURT\", \"MIAN\", \"YEAR\", \"EXPI\"] any = quantityFrequencyOfTheContractOrLeg1 then quantityFrequencyMultiplierOfTheContractOrLeg1 exists and quantityFrequencyMultiplierOfTheContractOrLeg1 > 0 else if quantityFrequencyOfTheContractOrLeg1 = \"ODMD\" then quantityFrequencyMultiplierOfTheContractOrLeg1 is absent";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0084_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperC.<String>of(MapperS.of(ActionTypeEnum.NEWT).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.MODI).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.CORR).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(ActionTypeEnum.REVI).map("to-string", ActionTypeEnum::toDisplayString)), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.Any).andNullSafe(areEqual(MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), MapperS.of("COMM"), CardinalityOperator.All)).getOrDefault(false)) {
					if (areEqual(MapperC.<String>of(MapperS.of("HOUL"), MapperS.of("DAIL"), MapperS.of("WEEK"), MapperS.of("MNTH"), MapperS.of("QURT"), MapperS.of("MIAN"), MapperS.of("YEAR"), MapperS.of("EXPI")), MapperS.of(mASTransactionReport).<String>map("getQuantityFrequencyOfTheContractOrLeg1", _mASTransactionReport -> _mASTransactionReport.getQuantityFrequencyOfTheContractOrLeg1()), CardinalityOperator.Any).getOrDefault(false)) {
						return exists(MapperS.of(mASTransactionReport).<Integer>map("getQuantityFrequencyMultiplierOfTheContractOrLeg1", _mASTransactionReport -> _mASTransactionReport.getQuantityFrequencyMultiplierOfTheContractOrLeg1())).andNullSafe(greaterThan(MapperS.of(mASTransactionReport).<Integer>map("getQuantityFrequencyMultiplierOfTheContractOrLeg1", _mASTransactionReport -> _mASTransactionReport.getQuantityFrequencyMultiplierOfTheContractOrLeg1()), MapperS.of(0), CardinalityOperator.All));
					}
					if (areEqual(MapperS.of(mASTransactionReport).<String>map("getQuantityFrequencyOfTheContractOrLeg1", _mASTransactionReport -> _mASTransactionReport.getQuantityFrequencyOfTheContractOrLeg1()), MapperS.of("ODMD"), CardinalityOperator.All).getOrDefault(false)) {
						return notExists(MapperS.of(mASTransactionReport).<Integer>map("getQuantityFrequencyMultiplierOfTheContractOrLeg1", _mASTransactionReport -> _mASTransactionReport.getQuantityFrequencyMultiplierOfTheContractOrLeg1()));
					}
					return ComparisonResult.ofEmpty();
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0084_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
