package drr.regulation.mas.rewrite.trade.validation.datarule;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.ActionTypeEnum;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.OtherPaymentReport;
import iso20022.auth030.mas.PaymentType4Code;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 5.58.0
 */
@RosettaDataRule("MASTransactionReportDTCC_MAS_BR_0127_04")
@ImplementedBy(MASTransactionReportDTCC_MAS_BR_0127_04.Default.class)
public interface MASTransactionReportDTCC_MAS_BR_0127_04 extends Validator<MASTransactionReport> {
	
	String NAME = "MASTransactionReportDTCC_MAS_BR_0127_04";
	String DEFINITION = "if ActionTypeEnum -> TERM to-string = actionType and assetClass = \"CRDT\" and (otherPayment -> amount exists or otherPayment -> currency exists or otherPayment -> payer exists or otherPayment -> receiver exists) then otherPayment -> paymentType exists and otherPayment -> paymentType all = PaymentType4Code -> UWIN and (if otherPayment -> paymentType count <> otherPayment -> amount count or otherPayment -> paymentType count <> otherPayment -> currency count or otherPayment -> paymentType count <> otherPayment -> date count or otherPayment -> paymentType count <> otherPayment -> payer count or otherPayment -> paymentType count <> otherPayment -> receiver count then False)";
	
	class Default implements MASTransactionReportDTCC_MAS_BR_0127_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			ComparisonResult result = executeDataRule(mASTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "MASTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(MASTransactionReport mASTransactionReport) {
			try {
				if (areEqual(MapperS.of(ActionTypeEnum.TERM).map("to-string", ActionTypeEnum::toDisplayString), MapperS.of(mASTransactionReport).<String>map("getActionType", _mASTransactionReport -> _mASTransactionReport.getActionType()), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(mASTransactionReport).<String>map("getAssetClass", _mASTransactionReport -> _mASTransactionReport.getAssetClass()), MapperS.of("CRDT"), CardinalityOperator.All)).andNullSafe(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount())).orNullSafe(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()))).orNullSafe(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()))).orNullSafe(exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver())))).getOrDefault(false)) {
					final ComparisonResult ifThenElseResult;
					if (notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPaymentReport -> otherPaymentReport.getAmount()).resultCount()), CardinalityOperator.Any).orNullSafe(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPaymentReport -> otherPaymentReport.getCurrency()).resultCount()), CardinalityOperator.Any)).orNullSafe(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<Date>map("getDate", otherPaymentReport -> otherPaymentReport.getDate()).resultCount()), CardinalityOperator.Any)).orNullSafe(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getPayer", otherPaymentReport -> otherPaymentReport.getPayer()).resultCount()), CardinalityOperator.Any)).orNullSafe(notEqual(MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()).resultCount()), MapperS.of(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPaymentReport -> otherPaymentReport.getReceiver()).resultCount()), CardinalityOperator.Any)).getOrDefault(false)) {
						ifThenElseResult = ComparisonResult.ofNullSafe(MapperS.of(false));
					} else {
						ifThenElseResult = ComparisonResult.ofEmpty();
					}
					return exists(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType())).andNullSafe(areEqual(MapperS.of(mASTransactionReport).<OtherPaymentReport>mapC("getOtherPayment", _mASTransactionReport -> _mASTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPaymentReport -> otherPaymentReport.getPaymentType()), MapperS.of(PaymentType4Code.UWIN), CardinalityOperator.All)).andNullSafe(ifThenElseResult);
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements MASTransactionReportDTCC_MAS_BR_0127_04 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, MASTransactionReport mASTransactionReport) {
			return Collections.emptyList();
		}
	}
}
