package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Address;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRoleEnum;
import cdm.base.staticdata.party.RelatedParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ExtractPartyFromRelatedPartyByRole;
import drr.regulation.techsprint.g20.mas.functions.LookupBookingLocation;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(BookingLocationAddressRule.BookingLocationAddressRuleDefault.class)
public abstract class BookingLocationAddressRule implements ReportFunction<TransactionReportInstruction, Address> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractPartyFromRelatedPartyByRole extractPartyFromRelatedPartyByRole;
	@Inject protected LookupBookingLocation lookupBookingLocation;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Address evaluate(TransactionReportInstruction input) {
		Address.AddressBuilder outputBuilder = doEvaluate(input);
		
		final Address output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(Address.class, output);
		}
		
		return output;
	}

	protected abstract Address.AddressBuilder doEvaluate(TransactionReportInstruction input);

	public static class BookingLocationAddressRuleDefault extends BookingLocationAddressRule {
		@Override
		protected Address.AddressBuilder doEvaluate(TransactionReportInstruction input) {
			Address.AddressBuilder output = Address.builder();
			return assignOutput(output, input);
		}
		
		protected Address.AddressBuilder assignOutput(Address.AddressBuilder output, TransactionReportInstruction input) {
			final MapperS<Party> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(extractPartyFromRelatedPartyByRole.evaluate(item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<RelatedParty>mapC("getRelatedParty", partyInformation -> partyInformation.getRelatedParty()).getMulti(), PartyRoleEnum.REPORTING_PARTY)));
			output = toBuilder(thenArg
				.mapSingleToItem(item -> MapperS.of(lookupBookingLocation.evaluate(item.get()))).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
