package drr.regulation.techsprint.g20.mas.reports;

import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyIdentifier;
import cdm.base.staticdata.party.metafields.ReferenceWithMetaParty;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.TransactionReportInstruction;
import javax.inject.Inject;


@ImplementedBy(InterestRatePayerLeg1Rule.InterestRatePayerLeg1RuleDefault.class)
public abstract class InterestRatePayerLeg1Rule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected InterestRatePayoutPayerRule interestRatePayoutPayerRule;
	@Inject protected IsInterestRatePayoutRule isInterestRatePayoutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class InterestRatePayerLeg1RuleDefault extends InterestRatePayerLeg1Rule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isInterestRatePayoutRule.evaluate(item.get()));
			final MapperS<ReferenceWithMetaParty> thenArg1 = thenArg0
				.mapSingleToItem(item -> {
					final Party party = interestRatePayoutPayerRule.evaluate(item.get());
					return party == null ? MapperS.<ReferenceWithMetaParty>ofNull() : MapperS.of(ReferenceWithMetaParty.builder().setValue(party).build());
				});
			final MapperC<FieldWithMetaString> thenArg2 = thenArg1
				.mapSingleToList(item -> item.<Party>map("Type coercion", referenceWithMetaParty -> referenceWithMetaParty == null ? null : referenceWithMetaParty.getValue()).<PartyIdentifier>mapC("getPartyId", party -> party.getPartyId()).<FieldWithMetaString>map("getIdentifier", partyIdentifier -> partyIdentifier.getIdentifier()));
			final FieldWithMetaString fieldWithMetaString = thenArg2
				.last().get();
			if (fieldWithMetaString == null) {
				output = null;
			} else {
				output = fieldWithMetaString.getValue();
			}
			
			return output;
		}
	}
}
